/***************************************************************** 
 * FILE        : DMA.h
 * 
 * DESCRIPTION : This is the header file describing the register
 *               set for:
 *               FARADAY
 *
 *               Please enter any bugs on GFORGE:
 * 				 http://gforge.freescale.net/projects/faraday-header/
 *				 Ensure you are logged in to enter bugs (top right of screen  use OneIT pass).
 *				 Tracker -> Bugs -> Submit New
 *				 Only the title (including the header name e.g. ADC.h) and description are 
 * 			 	 required  the rest can be left as default. 
 *				
 *               Alternatively send bugs to b06321@freescale.com
 *               using [FARADAY_HEADER] in subject        
 * 
 * COPYRIGHT   :(c) 2011, Freescale Semiconductor
 * 
 * VERSION     : 0
 * DATE        : 07 September 2011
 * AUTHOR      : b06321 
 * HISTORY     : 
 * v0: 	Alpha release made up from currently available BG. Not yet  
 * 		fully tested. Regs and bits are liable to change up until
 * 		tape-out.
 * v0.1: Updated to latest BG.
 * 
 *
 ******************************************************************/
 
/* ================================================================================
   ==============================      DMA      ==============================  
   ================================================================================ */
#ifndef DMA_H
#define DMA_H
#include "typedefs.h"

/* DMA - Peripheral register structure */
typedef struct DMA_MemMap {
  vuint32_t CR;              /* offset: 0x00000000*/
  vuint32_t ES;              /* offset: 0x00000004*/
  vuint8_t RESERVED0[4];
  vuint32_t ERQ;            /* offset: 0x0000000C*/
  vuint8_t RESERVED1[4];
  vuint32_t EEI;            /* offset: 0x00000014*/
  vuint8_t CEEI;            /* offset: 0x00000018*/
  vuint8_t SEEI;            /* offset: 0x00000019*/
  vuint8_t CERQ;            /* offset: 0x0000001A*/
  vuint8_t SERQ;            /* offset: 0x0000001B*/
  vuint8_t CDNE;            /* offset: 0x0000001C*/
  vuint8_t SSRT;            /* offset: 0x0000001D*/
  vuint8_t CERR;            /* offset: 0x0000001E*/
  vuint8_t CINT;            /* offset: 0x0000001F*/
  vuint8_t RESERVED2[4];
  vuint32_t INT;            /* offset: 0x00000024*/
  vuint8_t RESERVED3[4];
  vuint32_t ERR;            /* offset: 0x0000002C*/
  vuint8_t RESERVED4[4];
  vuint32_t HRS;            /* offset: 0x00000034*/
  vuint8_t RESERVED5[200];
  vuint8_t DCHPRI3;            /* offset: 0x00000100*/
  vuint8_t DCHPRI2;            /* offset: 0x00000101*/
  vuint8_t DCHPRI1;            /* offset: 0x00000102*/
  vuint8_t DCHPRI0;            /* offset: 0x00000103*/ 
  vuint8_t DCHPRI7;            /* offset: 0x00000104*/  
  vuint8_t DCHPRI6;            /* offset: 0x00000105*/
  vuint8_t DCHPRI5;            /* offset: 0x00000106*/
  vuint8_t DCHPRI4;            /* offset: 0x00000107*/
  vuint8_t DCHPRI11;           /* offset: 0x00000108*/
  vuint8_t DCHPRI10;           /* offset: 0x00000109*/
  vuint8_t DCHPRI9;            /* offset: 0x0000010A*/
  vuint8_t DCHPRI8;            /* offset: 0x0000010B*/
  vuint8_t DCHPRI15;           /* offset: 0x0000010C*/
  vuint8_t DCHPRI14;           /* offset: 0x0000010D*/
  vuint8_t DCHPRI13;           /* offset: 0x0000010E*/
  vuint8_t DCHPRI12;           /* offset: 0x0000010F*/
  vuint8_t DCHPRI19;           /* offset: 0x00000110*/
  vuint8_t DCHPRI18;           /* offset: 0x00000111*/
  vuint8_t DCHPRI17;           /* offset: 0x00000112*/
  vuint8_t DCHPRI16;           /* offset: 0x00000113*/
  vuint8_t DCHPRI23;           /* offset: 0x00000114*/
  vuint8_t DCHPRI22;           /* offset: 0x00000115*/
  vuint8_t DCHPRI21;           /* offset: 0x00000116*/
  vuint8_t DCHPRI20;           /* offset: 0x00000117*/
  vuint8_t DCHPRI27;           /* offset: 0x00000118*/
  vuint8_t DCHPRI26;           /* offset: 0x00000119*/
  vuint8_t DCHPRI25;           /* offset: 0x0000011A*/
  vuint8_t DCHPRI24;           /* offset: 0x0000011B*/
  vuint8_t DCHPRI31;           /* offset: 0x0000011C*/
  vuint8_t DCHPRI30;           /* offset: 0x0000011D*/
  vuint8_t DCHPRI29;           /* offset: 0x0000011E*/
  vuint8_t DCHPRI28;           /* offset: 0x0000011F*/
  vuint8_t RESERVED6[3808];
  vuint32_t TCD0_WORD0;         /* offset: 0x00001000*/
  vuint32_t TCD0_WORD1;         /* offset: 0x00001004*/
  vuint32_t TCD0_WORD2;         /* offset: 0x00001008*/
  vuint32_t TCD0_WORD3;         /* offset: 0x0000100C*/
  vuint32_t TCD0_WORD4;         /* offset: 0x00001010*/
  vuint32_t TCD0_WORD5;         /* offset: 0x00001014*/
  vuint32_t TCD0_WORD6;         /* offset: 0x00001018*/
  vuint32_t TCD0_WORD7;         /* offset: 0x0000101C*/
  vuint32_t TCD1_WORD0;         /* offset: 0x00001020*/
  vuint32_t TCD1_WORD1;         /* offset: 0x00001024*/
  vuint32_t TCD1_WORD2;         /* offset: 0x00001028*/
  vuint32_t TCD1_WORD3;         /* offset: 0x0000102C*/
  vuint32_t TCD1_WORD4;         /* offset: 0x00001030*/
  vuint32_t TCD1_WORD5;         /* offset: 0x00001034*/
  vuint32_t TCD1_WORD6;         /* offset: 0x00001038*/
  vuint32_t TCD1_WORD7;         /* offset: 0x0000103C*/
  vuint32_t TCD2_WORD0;         /* offset: 0x00001040*/
  vuint32_t TCD2_WORD1;         /* offset: 0x00001044*/
  vuint32_t TCD2_WORD2;         /* offset: 0x00001048*/
  vuint32_t TCD2_WORD3;         /* offset: 0x0000104C*/
  vuint32_t TCD2_WORD4;         /* offset: 0x00001050*/
  vuint32_t TCD2_WORD5;         /* offset: 0x00001054*/
  vuint32_t TCD2_WORD6;         /* offset: 0x00001058*/
  vuint32_t TCD2_WORD7;         /* offset: 0x0000105C*/
  vuint32_t TCD3_WORD0;         /* offset: 0x00001060*/
  vuint32_t TCD3_WORD1;         /* offset: 0x00001064*/
  vuint32_t TCD3_WORD2;         /* offset: 0x00001068*/
  vuint32_t TCD3_WORD3;         /* offset: 0x0000106C*/
  vuint32_t TCD3_WORD4;         /* offset: 0x00001070*/
  vuint32_t TCD3_WORD5;         /* offset: 0x00001074*/
  vuint32_t TCD3_WORD6;         /* offset: 0x00001078*/
  vuint32_t TCD3_WORD7;         /* offset: 0x0000107C*/
  vuint32_t TCD4_WORD0;         /* offset: 0x00001080*/
  vuint32_t TCD4_WORD1;         /* offset: 0x00001084*/
  vuint32_t TCD4_WORD2;         /* offset: 0x00001088*/
  vuint32_t TCD4_WORD3;         /* offset: 0x0000108C*/
  vuint32_t TCD4_WORD4;         /* offset: 0x00001090*/
  vuint32_t TCD4_WORD5;         /* offset: 0x00001094*/
  vuint32_t TCD4_WORD6;         /* offset: 0x00001098*/
  vuint32_t TCD4_WORD7;         /* offset: 0x0000109C*/
  vuint32_t TCD5_WORD0;         /* offset: 0x000010A0*/
  vuint32_t TCD5_WORD1;         /* offset: 0x000010A4*/
  vuint32_t TCD5_WORD2;         /* offset: 0x000010A8*/
  vuint32_t TCD5_WORD3;         /* offset: 0x000010AC*/
  vuint32_t TCD5_WORD4;         /* offset: 0x000010B0*/
  vuint32_t TCD5_WORD5;         /* offset: 0x000010B4*/
  vuint32_t TCD5_WORD6;         /* offset: 0x000010B8*/
  vuint32_t TCD5_WORD7;         /* offset: 0x000010BC*/
  vuint32_t TCD6_WORD0;         /* offset: 0x000010C0*/
  vuint32_t TCD6_WORD1;         /* offset: 0x000010C4*/
  vuint32_t TCD6_WORD2;         /* offset: 0x000010C8*/
  vuint32_t TCD6_WORD3;         /* offset: 0x000010CC*/
  vuint32_t TCD6_WORD4;         /* offset: 0x000010D0*/
  vuint32_t TCD6_WORD5;         /* offset: 0x000010D4*/
  vuint32_t TCD6_WORD6;         /* offset: 0x000010D8*/
  vuint32_t TCD6_WORD7;         /* offset: 0x000010DC*/
  vuint32_t TCD7_WORD0;         /* offset: 0x000010E0*/
  vuint32_t TCD7_WORD1;         /* offset: 0x000010E4*/
  vuint32_t TCD7_WORD2;         /* offset: 0x000010E8*/
  vuint32_t TCD7_WORD3;         /* offset: 0x000010EC*/
  vuint32_t TCD7_WORD4;         /* offset: 0x000010F0*/
  vuint32_t TCD7_WORD5;         /* offset: 0x000010F4*/
  vuint32_t TCD7_WORD6;         /* offset: 0x000010F8*/
  vuint32_t TCD7_WORD7;         /* offset: 0x000010FC*/
  vuint32_t TCD8_WORD0;         /* offset: 0x00001100*/
  vuint32_t TCD8_WORD1;         /* offset: 0x00001104*/
  vuint32_t TCD8_WORD2;         /* offset: 0x00001108*/
  vuint32_t TCD8_WORD3;         /* offset: 0x0000110C*/
  vuint32_t TCD8_WORD4;         /* offset: 0x00001110*/
  vuint32_t TCD8_WORD5;         /* offset: 0x00001114*/
  vuint32_t TCD8_WORD6;         /* offset: 0x00001118*/
  vuint32_t TCD8_WORD7;         /* offset: 0x0000111C*/
  vuint32_t TCD9_WORD0;         /* offset: 0x00001120*/
  vuint32_t TCD9_WORD1;         /* offset: 0x00001124*/
  vuint32_t TCD9_WORD2;         /* offset: 0x00001128*/
  vuint32_t TCD9_WORD3;         /* offset: 0x0000112C*/
  vuint32_t TCD9_WORD4;         /* offset: 0x00001130*/
  vuint32_t TCD9_WORD5;         /* offset: 0x00001134*/
  vuint32_t TCD9_WORD6;         /* offset: 0x00001138*/
  vuint32_t TCD9_WORD7;         /* offset: 0x0000113C*/
  vuint32_t TCD10_WORD0;         /* offset: 0x00001140*/
  vuint32_t TCD10_WORD1;         /* offset: 0x00001144*/
  vuint32_t TCD10_WORD2;         /* offset: 0x00001148*/
  vuint32_t TCD10_WORD3;         /* offset: 0x0000114C*/
  vuint32_t TCD10_WORD4;         /* offset: 0x00001150*/
  vuint32_t TCD10_WORD5;         /* offset: 0x00001154*/
  vuint32_t TCD10_WORD6;         /* offset: 0x00001158*/
  vuint32_t TCD10_WORD7;         /* offset: 0x0000115C*/
  vuint32_t TCD11_WORD0;         /* offset: 0x00001160*/
  vuint32_t TCD11_WORD1;         /* offset: 0x00001164*/
  vuint32_t TCD11_WORD2;         /* offset: 0x00001168*/
  vuint32_t TCD11_WORD3;         /* offset: 0x0000116C*/
  vuint32_t TCD11_WORD4;         /* offset: 0x00001170*/
  vuint32_t TCD11_WORD5;         /* offset: 0x00001174*/
  vuint32_t TCD11_WORD6;         /* offset: 0x00001178*/
  vuint32_t TCD11_WORD7;         /* offset: 0x0000117C*/
  vuint32_t TCD12_WORD0;         /* offset: 0x00001180*/
  vuint32_t TCD12_WORD1;         /* offset: 0x00001184*/
  vuint32_t TCD12_WORD2;         /* offset: 0x00001188*/
  vuint32_t TCD12_WORD3;         /* offset: 0x0000118C*/
  vuint32_t TCD12_WORD4;         /* offset: 0x00001190*/
  vuint32_t TCD12_WORD5;         /* offset: 0x00001194*/
  vuint32_t TCD12_WORD6;         /* offset: 0x00001198*/
  vuint32_t TCD12_WORD7;         /* offset: 0x0000119C*/
  vuint32_t TCD13_WORD0;         /* offset: 0x000011A0*/
  vuint32_t TCD13_WORD1;         /* offset: 0x000011A4*/
  vuint32_t TCD13_WORD2;         /* offset: 0x000011A8*/
  vuint32_t TCD13_WORD3;         /* offset: 0x000011AC*/
  vuint32_t TCD13_WORD4;         /* offset: 0x000011B0*/
  vuint32_t TCD13_WORD5;         /* offset: 0x000011B4*/
  vuint32_t TCD13_WORD6;         /* offset: 0x000011B8*/
  vuint32_t TCD13_WORD7;         /* offset: 0x000011BC*/
  vuint32_t TCD14_WORD0;         /* offset: 0x000011C0*/
  vuint32_t TCD14_WORD1;         /* offset: 0x000011C4*/
  vuint32_t TCD14_WORD2;         /* offset: 0x000011C8*/
  vuint32_t TCD14_WORD3;         /* offset: 0x000011CC*/
  vuint32_t TCD14_WORD4;         /* offset: 0x000011D0*/
  vuint32_t TCD14_WORD5;         /* offset: 0x000011D4*/
  vuint32_t TCD14_WORD6;         /* offset: 0x000011D8*/
  vuint32_t TCD14_WORD7;         /* offset: 0x000011DC*/
  vuint32_t TCD15_WORD0;         /* offset: 0x000011E0*/
  vuint32_t TCD15_WORD1;         /* offset: 0x000011E4*/
  vuint32_t TCD15_WORD2;         /* offset: 0x000011E8*/
  vuint32_t TCD15_WORD3;         /* offset: 0x000011EC*/
  vuint32_t TCD15_WORD4;         /* offset: 0x000011F0*/
  vuint32_t TCD15_WORD5;         /* offset: 0x000011F4*/
  vuint32_t TCD15_WORD6;         /* offset: 0x000011F8*/
  vuint32_t TCD15_WORD7;         /* offset: 0x000011FC*/
  vuint32_t TCD16_WORD0;         /* offset: 0x00001200*/
  vuint32_t TCD16_WORD1;         /* offset: 0x00001204*/
  vuint32_t TCD16_WORD2;         /* offset: 0x00001208*/
  vuint32_t TCD16_WORD3;         /* offset: 0x0000120C*/
  vuint32_t TCD16_WORD4;         /* offset: 0x00001210*/
  vuint32_t TCD16_WORD5;         /* offset: 0x00001214*/
  vuint32_t TCD16_WORD6;         /* offset: 0x00001218*/
  vuint32_t TCD16_WORD7;         /* offset: 0x0000121C*/
  vuint32_t TCD17_WORD0;         /* offset: 0x00001220*/
  vuint32_t TCD17_WORD1;         /* offset: 0x00001224*/
  vuint32_t TCD17_WORD2;         /* offset: 0x00001228*/
  vuint32_t TCD17_WORD3;         /* offset: 0x0000122C*/
  vuint32_t TCD17_WORD4;         /* offset: 0x00001230*/
  vuint32_t TCD17_WORD5;         /* offset: 0x00001234*/
  vuint32_t TCD17_WORD6;         /* offset: 0x00001238*/
  vuint32_t TCD17_WORD7;         /* offset: 0x0000123C*/
  vuint32_t TCD18_WORD0;         /* offset: 0x00001240*/
  vuint32_t TCD18_WORD1;         /* offset: 0x00001244*/
  vuint32_t TCD18_WORD2;         /* offset: 0x00001248*/
  vuint32_t TCD18_WORD3;         /* offset: 0x0000124C*/
  vuint32_t TCD18_WORD4;         /* offset: 0x00001250*/
  vuint32_t TCD18_WORD5;         /* offset: 0x00001254*/
  vuint32_t TCD18_WORD6;         /* offset: 0x00001258*/
  vuint32_t TCD18_WORD7;         /* offset: 0x0000125C*/
  vuint32_t TCD19_WORD0;         /* offset: 0x00001260*/
  vuint32_t TCD19_WORD1;         /* offset: 0x00001264*/
  vuint32_t TCD19_WORD2;         /* offset: 0x00001268*/
  vuint32_t TCD19_WORD3;         /* offset: 0x0000126C*/
  vuint32_t TCD19_WORD4;         /* offset: 0x00001270*/
  vuint32_t TCD19_WORD5;         /* offset: 0x00001274*/
  vuint32_t TCD19_WORD6;         /* offset: 0x00001278*/
  vuint32_t TCD19_WORD7;         /* offset: 0x0000127C*/
  vuint32_t TCD20_WORD0;         /* offset: 0x00001280*/
  vuint32_t TCD20_WORD1;         /* offset: 0x00001284*/
  vuint32_t TCD20_WORD2;         /* offset: 0x00001288*/
  vuint32_t TCD20_WORD3;         /* offset: 0x0000128C*/
  vuint32_t TCD20_WORD4;         /* offset: 0x00001290*/
  vuint32_t TCD20_WORD5;         /* offset: 0x00001294*/
  vuint32_t TCD20_WORD6;         /* offset: 0x00001298*/
  vuint32_t TCD20_WORD7;         /* offset: 0x0000129C*/
  vuint32_t TCD21_WORD0;         /* offset: 0x000012A0*/
  vuint32_t TCD21_WORD1;         /* offset: 0x000012A4*/
  vuint32_t TCD21_WORD2;         /* offset: 0x000012A8*/
  vuint32_t TCD21_WORD3;         /* offset: 0x000012AC*/
  vuint32_t TCD21_WORD4;         /* offset: 0x000012B0*/
  vuint32_t TCD21_WORD5;         /* offset: 0x000012B4*/
  vuint32_t TCD21_WORD6;         /* offset: 0x000012B8*/
  vuint32_t TCD21_WORD7;         /* offset: 0x000012BC*/
  vuint32_t TCD22_WORD0;         /* offset: 0x000012C0*/
  vuint32_t TCD22_WORD1;         /* offset: 0x000012C4*/
  vuint32_t TCD22_WORD2;         /* offset: 0x000012C8*/
  vuint32_t TCD22_WORD3;         /* offset: 0x000012CC*/
  vuint32_t TCD22_WORD4;         /* offset: 0x000012D0*/
  vuint32_t TCD22_WORD5;         /* offset: 0x000012D4*/
  vuint32_t TCD22_WORD6;         /* offset: 0x000012D8*/
  vuint32_t TCD22_WORD7;         /* offset: 0x000012DC*/
  vuint32_t TCD23_WORD0;         /* offset: 0x000012E0*/
  vuint32_t TCD23_WORD1;         /* offset: 0x000012E4*/
  vuint32_t TCD23_WORD2;         /* offset: 0x000012E8*/
  vuint32_t TCD23_WORD3;         /* offset: 0x000012EC*/
  vuint32_t TCD23_WORD4;         /* offset: 0x000012F0*/
  vuint32_t TCD23_WORD5;         /* offset: 0x000012F4*/
  vuint32_t TCD23_WORD6;         /* offset: 0x000012F8*/
  vuint32_t TCD23_WORD7;         /* offset: 0x000012FC*/
  vuint32_t TCD24_WORD0;         /* offset: 0x00001300*/
  vuint32_t TCD24_WORD1;         /* offset: 0x00001304*/
  vuint32_t TCD24_WORD2;         /* offset: 0x00001308*/
  vuint32_t TCD24_WORD3;         /* offset: 0x0000130C*/
  vuint32_t TCD24_WORD4;         /* offset: 0x00001310*/
  vuint32_t TCD24_WORD5;         /* offset: 0x00001314*/
  vuint32_t TCD24_WORD6;         /* offset: 0x00001318*/
  vuint32_t TCD24_WORD7;         /* offset: 0x0000131C*/
  vuint32_t TCD25_WORD0;         /* offset: 0x00001320*/
  vuint32_t TCD25_WORD1;         /* offset: 0x00001324*/
  vuint32_t TCD25_WORD2;         /* offset: 0x00001328*/
  vuint32_t TCD25_WORD3;         /* offset: 0x0000132C*/
  vuint32_t TCD25_WORD4;         /* offset: 0x00001330*/
  vuint32_t TCD25_WORD5;         /* offset: 0x00001334*/
  vuint32_t TCD25_WORD6;         /* offset: 0x00001338*/
  vuint32_t TCD25_WORD7;         /* offset: 0x0000133C*/
  vuint32_t TCD26_WORD0;         /* offset: 0x00001340*/
  vuint32_t TCD26_WORD1;         /* offset: 0x00001344*/
  vuint32_t TCD26_WORD2;         /* offset: 0x00001348*/
  vuint32_t TCD26_WORD3;         /* offset: 0x0000134C*/
  vuint32_t TCD26_WORD4;         /* offset: 0x00001350*/
  vuint32_t TCD26_WORD5;         /* offset: 0x00001354*/
  vuint32_t TCD26_WORD6;         /* offset: 0x00001358*/
  vuint32_t TCD26_WORD7;         /* offset: 0x0000135C*/
  vuint32_t TCD27_WORD0;         /* offset: 0x00001360*/
  vuint32_t TCD27_WORD1;         /* offset: 0x00001364*/
  vuint32_t TCD27_WORD2;         /* offset: 0x00001368*/
  vuint32_t TCD27_WORD3;         /* offset: 0x0000136C*/
  vuint32_t TCD27_WORD4;         /* offset: 0x00001370*/
  vuint32_t TCD27_WORD5;         /* offset: 0x00001374*/
  vuint32_t TCD27_WORD6;         /* offset: 0x00001378*/
  vuint32_t TCD27_WORD7;         /* offset: 0x0000137C*/
  vuint32_t TCD28_WORD0;         /* offset: 0x00001380*/
  vuint32_t TCD28_WORD1;         /* offset: 0x00001384*/
  vuint32_t TCD28_WORD2;         /* offset: 0x00001388*/
  vuint32_t TCD28_WORD3;         /* offset: 0x0000138C*/
  vuint32_t TCD28_WORD4;         /* offset: 0x00001390*/
  vuint32_t TCD28_WORD5;         /* offset: 0x00001394*/
  vuint32_t TCD28_WORD6;         /* offset: 0x00001398*/
  vuint32_t TCD28_WORD7;         /* offset: 0x0000139C*/
  vuint32_t TCD29_WORD0;         /* offset: 0x000013A0*/
  vuint32_t TCD29_WORD1;         /* offset: 0x000013A4*/
  vuint32_t TCD29_WORD2;         /* offset: 0x000013A8*/
  vuint32_t TCD29_WORD3;         /* offset: 0x000013AC*/
  vuint32_t TCD29_WORD4;         /* offset: 0x000013B0*/
  vuint32_t TCD29_WORD5;         /* offset: 0x000013B4*/
  vuint32_t TCD29_WORD6;         /* offset: 0x000013B8*/
  vuint32_t TCD29_WORD7;         /* offset: 0x000013BC*/
  vuint32_t TCD30_WORD0;         /* offset: 0x000013C0*/
  vuint32_t TCD30_WORD1;         /* offset: 0x000013C4*/
  vuint32_t TCD30_WORD2;         /* offset: 0x000013C8*/
  vuint32_t TCD30_WORD3;         /* offset: 0x000013CC*/
  vuint32_t TCD30_WORD4;         /* offset: 0x000013D0*/
  vuint32_t TCD30_WORD5;         /* offset: 0x000013D4*/
  vuint32_t TCD30_WORD6;         /* offset: 0x000013D8*/
  vuint32_t TCD30_WORD7;         /* offset: 0x000013DC*/
  vuint32_t TCD31_WORD0;         /* offset: 0x000013E0*/
  vuint32_t TCD31_WORD1;         /* offset: 0x000013E4*/
  vuint32_t TCD31_WORD2;         /* offset: 0x000013E8*/
  vuint32_t TCD31_WORD3;         /* offset: 0x000013EC*/
  vuint32_t TCD31_WORD4;         /* offset: 0x000013F0*/
  vuint32_t TCD31_WORD5;         /* offset: 0x000013F4*/
  vuint32_t TCD31_WORD6;         /* offset: 0x000013F8*/
  vuint32_t TCD31_WORD7;         /* offset: 0x000013FC*/
} volatile *DMA_MemMapPtr;

/*for "standard" format TCD (when EDMA.TCD[x].CITER.E_LINK==BITER.E_LINK=0) */
    struct EDMA_TCD_STD_tag {
        //WORD0
        vuint32_t SADDR;                /* source address */
        //WORD1
        vint16_t SOFF;                  /* signed source address offset */
        vuint16_t DSIZE:3;              /* destination transfer size */
        vuint16_t DMOD:5;               /* destination address modulo */
        vuint16_t SSIZE:3;              /* source transfer size */
        vuint16_t SMOD:5;               /* source address modulo */
        //WORD2
        union {
            vuint32_t R;
            struct {
                vuint32_t NBYTES:10;
                int32_t   MLOFF:20;
                vuint32_t DMLOE:1;
                vuint32_t SMLOE:1;
            } B;
        } NBYTESu;                      /* Region Descriptor Alternate Access Control n */
        //WORD3    
        vint32_t SLAST;                 /* last destination address adjustment, or
                                          scatter/gather address (if e_sg = 1) */
        //WORD4
        vuint32_t DADDR;                /* destination address */
        //WORD5
        vint16_t DOFF;                  /* signed destination address offset */
        vuint16_t CITER:15;
        vuint16_t CITERE_LINK:1;
        //WORD6
        vint32_t DLAST_SGA;
        //WORD7
        vuint16_t START:1;              /* explicit channel start */
        vuint16_t INT_MAJ:1;            /* interrupt on major loop completion */
        vuint16_t INT_HALF:1;           /* interrupt on citer = (biter >> 1) */
        vuint16_t D_REQ:1;              /* disable ipd_req when done */
        vuint16_t E_SG:1;               /* enable scatter/gather descriptor */
        vuint16_t MAJORE_LINK:1;        /* enable channel-to-channel link */
        vuint16_t ACTIVE:1;             /* channel active */
        vuint16_t DONE:1;               /* channel done */
        vuint16_t MAJORLINKCH:6;        /* enable channel-to-channel link */
        vuint16_t BWC:2;                /* bandwidth control */
        vuint16_t BITER:15;
        vuint16_t BITERE_LINK:1;        /* beginning ("major") iteration count */
    };                                  /* end of EDMA_TCD_STD_tag */

/*for "channel link" format TCD (when EDMA.TCD[x].CITER.E_LINK==BITER.E_LINK=1)*/
    struct EDMA_TCD_CHLINK_tag {

        vuint32_t SADDR;                /* source address */

        vuint16_t SMOD:5;               /* source address modulo */
        vuint16_t SSIZE:3;              /* source transfer size */
        vuint16_t DMOD:5;               /* destination address modulo */
        vuint16_t DSIZE:3;              /* destination transfer size */
        vint16_t SOFF;                  /* signed source address offset */

        union {
            vuint32_t R;
            struct {
                vuint32_t SMLOE:1;
                vuint32_t DMLOE:1;
                int32_t   MLOFF:20;
                vuint32_t NBYTES:10;
            } B;
        } NBYTESu;                      /* Region Descriptor Alternate Access Control n */
        vint32_t SLAST;                 /* last destination address adjustment, or
                                          scatter/gather address (if e_sg = 1) */

        vuint32_t DADDR;                /* destination address */

        vuint16_t CITERE_LINK:1;
        vuint16_t CITERLINKCH:6;
        vuint16_t CITER:9;

        vint16_t DOFF;                  /* signed destination address offset */

        vint32_t DLAST_SGA;

        vuint16_t BITERE_LINK:1;        /* beginning (major) iteration count */
        vuint16_t BITERLINKCH:6;
        vuint16_t BITER:9;

        vuint16_t BWC:2;                /* bandwidth control */
        vuint16_t MAJORLINKCH:6;        /* enable channel-to-channel link */
        vuint16_t DONE:1;               /* channel done */
        vuint16_t ACTIVE:1;             /* channel active */
        vuint16_t MAJORE_LINK:1;        /* enable channel-to-channel link */
        vuint16_t E_SG:1;               /* enable scatter/gather descriptor */
        vuint16_t D_REQ:1;              /* disable ipd_req when done */
        vuint16_t INT_HALF:1;           /* interrupt on citer = (biter >> 1) */
        vuint16_t INT_MAJ:1;            /* interrupt on major loop completion */
        vuint16_t START:1;              /* explicit channel start */    

    };     

/* DMA - Peripheral register structure */
struct EDMA_tag {
  //vuint32_t CR;              /* offset: 0x00000000*/
  union {
            vuint32_t R;
            struct {
                vuint32_t:1;//vuint32_t EBW:1;
                vuint32_t EDBG:1;
                vuint32_t ERCA:1;
                vuint32_t ERGA:1;
                vuint32_t HOE:1;
                vuint32_t HALT:1;
                vuint32_t CLM:1;
                vuint32_t EMLM:1;
                vuint32_t GRP0PRI:2;
                vuint32_t GRP1PRI:2;
                //vuint32_t GRP2PRI:2;
                //vuint32_t GRP3PRI:2;
                vuint32_t:4;
                vuint32_t ECX:1;
                vuint32_t CX:1;
                vuint32_t:14;
            } B;
        } CR;      
  //vuint32_t ES;              /* offset: 0x00000004*/
  union {
            vuint32_t R;
            struct {
                vuint32_t DBE:1;
                vuint32_t SBE:1;
                vuint32_t SGE:1;
                vuint32_t NCE:1;
                vuint32_t DOE:1;
                vuint32_t DAE:1;
                vuint32_t SOE:1;
                vuint32_t SAE:1;
                vuint32_t ERRCHN:6;
                vuint32_t CPE:1;
                vuint32_t GPE:1;
                vuint32_t ECX:1;
                vuint32_t:14;
                vuint32_t VLD:1;
            } B;
        } ES;                           /* Error Status Register */
  
  vuint8_t RESERVED0[4];
  
//  vuint32_t ERQ;            /* offset: 0x0000000C*/
	  union {
            vuint32_t R;
            struct {
                vuint32_t ERQ00:1;
                vuint32_t ERQ01:1;
                vuint32_t ERQ02:1;
                vuint32_t ERQ03:1;
                vuint32_t ERQ04:1;
                vuint32_t ERQ05:1;
                vuint32_t ERQ06:1;
                vuint32_t ERQ07:1;
                vuint32_t ERQ08:1;
                vuint32_t ERQ09:1;
                vuint32_t ERQ10:1;
                vuint32_t ERQ11:1;
                vuint32_t ERQ12:1;
                vuint32_t ERQ13:1;
                vuint32_t ERQ14:1;
                vuint32_t ERQ15:1;
		vuint32_t ERQ16:1;
                vuint32_t ERQ17:1;
                vuint32_t ERQ18:1;
                vuint32_t ERQ19:1;
                vuint32_t ERQ20:1;
                vuint32_t ERQ21:1;
                vuint32_t ERQ22:1;
                vuint32_t ERQ23:1;
                vuint32_t ERQ24:1;
                vuint32_t ERQ25:1;
                vuint32_t ERQ26:1;
                vuint32_t ERQ27:1;
                vuint32_t ERQ28:1;
                vuint32_t ERQ29:1;
                vuint32_t ERQ30:1;
                vuint32_t ERQ31:1;
            } B;
        } ERQL;

  vuint8_t RESERVED1[4];
  
  //vuint32_t EEI;            /* offset: 0x00000014*/
  
  union {
            vuint32_t R;
            struct {
                vuint32_t EEI00:1;
                vuint32_t EEI01:1;
                vuint32_t EEI02:1;
                vuint32_t EEI03:1;
                vuint32_t EEI04:1;
                vuint32_t EEI05:1;
                vuint32_t EEI06:1;
                vuint32_t EEI07:1;
                vuint32_t EEI08:1;
                vuint32_t EEI09:1;
                vuint32_t EEI10:1;
                vuint32_t EEI11:1;
                vuint32_t EEI12:1;
                vuint32_t EEI13:1;
                vuint32_t EEI14:1;
                vuint32_t EEI15:1;
		vuint32_t EEI16:1;
                vuint32_t EEI17:1;
                vuint32_t EEI18:1;
                vuint32_t EEI19:1;
                vuint32_t EEI20:1;
                vuint32_t EEI21:1;
                vuint32_t EEI22:1;
                vuint32_t EEI23:1;
                vuint32_t EEI24:1;
                vuint32_t EEI25:1;
                vuint32_t EEI26:1;
                vuint32_t EEI27:1;
                vuint32_t EEI28:1;
                vuint32_t EEI29:1;
                vuint32_t EEI30:1;
                vuint32_t EEI31:1;
            } B;
        } EEIL;                         /* DMA Enable Error Interrupt LowHigh */
  
  //vuint8_t CEEI;            /* offset: 0x00000018*/
  union {
            vuint8_t R;
            struct {
                vuint8_t CEEI:5;
                vuint8_t:1;
                vuint8_t CAEE:1;
                vuint8_t NOP:1;
                
            } B;
        } CEEI;                         /* DMA Clear Enable Error Interrupt Register */
  //vuint8_t SEEI;            /* offset: 0x00000019*/
  union {
            vuint8_t R;
            struct {
                vuint8_t SEEI:5;
                vuint8_t:1;
                vuint8_t SAEE:1;
                vuint8_t NOP:1;
            } B;
        } SEEI;                         /* DMA Set Enable Error Interrupt Register */
  
  //vuint8_t CERQ;            /* offset: 0x0000001A*/
  union {
            vuint8_t R;
            struct {
            vuint8_t CERQ:5;
            vuint8_t:1;
            vuint8_t CAER:1;
            vuint8_t NOP:1;
            } B;
        } CERQ;                         /* DMA Clear Enable Request Register */
  
  //vuint8_t SERQ;            /* offset: 0x0000001B*/
  union {
            vuint8_t R;
            struct {
              vuint8_t SERQ:5;
              vuint8_t:1;
              vuint8_t CAER:1;
              vuint8_t NOP:1;
            } B;
        } SERQ;                         /* DMA Set Enable Request Register */
  
  //vuint8_t CDNE;            /* offset: 0x0000001C*/
  union {
            vuint8_t R;
            struct {
              vuint8_t CDNE:5;  
              vuint8_t:1;
              vuint8_t CADN:1;
              vuint8_t NOP:1;
            } B;
        } CDNE;                         /* Clear Done Status Bit Register */
  
  
  //vuint8_t SSRT;            /* offset: 0x0000001D*/
  union {
            vuint8_t R;
            struct {
              vuint8_t SSB:5;
              vuint8_t:1;
              vuint8_t SAST:1;
              vuint8_t NOP:1;
            } B;
        } SSRT;                         /* Set Start Bit Register */
		
  //vuint8_t CERR;            /* offset: 0x0000001E*/
  union {
            vuint8_t R;
            struct {
                vuint8_t CER:5;
                vuint8_t:1;
                vuint8_t CAEI:1;
                vuint8_t NOP:1;
  
            } B;
        } CERR;                         /* DMA Clear error Register */
		
  //vuint8_t CINT;            /* offset: 0x0000001F*/
  union {
            vuint8_t R;
            struct {
              vuint8_t CINT:5;  
              vuint8_t:1;
              vuint8_t CAIR:1;
              vuint8_t NOP:1;
            } B;
        } CINT;                         /* DMA Clear Interrupt Request Register */
  vuint8_t RESERVED2[4];
  
  //vuint32_t INT;            /* offset: 0x00000024*/
  union {
            vuint32_t R;
            struct {
                vuint32_t INT00:1;
                vuint32_t INT01:1;
                vuint32_t INT02:1;
                vuint32_t INT03:1;
                vuint32_t INT04:1;
                vuint32_t INT05:1;
                vuint32_t INT06:1;
                vuint32_t INT07:1;
                vuint32_t INT08:1;
                vuint32_t INT09:1;
                vuint32_t INT10:1;
                vuint32_t INT11:1;
                vuint32_t INT12:1;
                vuint32_t INT13:1;
                vuint32_t INT14:1;
                vuint32_t INT15:1;
		vuint32_t INT16:1;
                vuint32_t INT17:1;
                vuint32_t INT18:1;
                vuint32_t INT19:1;
                vuint32_t INT20:1;
                vuint32_t INT21:1;
                vuint32_t INT22:1;
                vuint32_t INT23:1;
                vuint32_t INT24:1;
                vuint32_t INT25:1;
                vuint32_t INT26:1;
                vuint32_t INT27:1;
                vuint32_t INT28:1;
                vuint32_t INT29:1;
                vuint32_t INT30:1;
                vuint32_t INT31:1;
            } B;
        } INTL;                         /* DMA Interrupt Request Low */
  
  vuint8_t RESERVED3[4];
  //vuint32_t ERR;            /* offset: 0x0000002C*/
  union {
            vuint32_t R;
            struct {
		vuint32_t ERR00:1;
                vuint32_t ERR01:1;
                vuint32_t ERR02:1;
                vuint32_t ERR03:1;
                vuint32_t ERR04:1;
                vuint32_t ERR05:1;
                vuint32_t ERR06:1;
                vuint32_t ERR07:1;
                vuint32_t ERR08:1;
                vuint32_t ERR09:1;
                vuint32_t ERR10:1;
                vuint32_t ERR11:1;
                vuint32_t ERR12:1;
                vuint32_t ERR13:1;
                vuint32_t ERR14:1;
                vuint32_t ERR15:1;
                vuint32_t ERR16:1;
                vuint32_t ERR17:1;
                vuint32_t ERR18:1;
                vuint32_t ERR19:1;
                vuint32_t ERR20:1;
                vuint32_t ERR21:1;
                vuint32_t ERR22:1;
                vuint32_t ERR23:1;
                vuint32_t ERR24:1;
                vuint32_t ERR25:1;
                vuint32_t ERR26:1;
                vuint32_t ERR27:1;
                vuint32_t ERR28:1;
                vuint32_t ERR29:1;
                vuint32_t ERR30:1;
                vuint32_t ERR31:1;
            } B;
        } ERRL;                         /* DMA Error Low */
  
  vuint8_t RESERVED4[4];
  //vuint32_t HRS;            /* offset: 0x00000034*/
  union {
            vuint32_t R;
            struct {
                vuint32_t HRS00:1;
                vuint32_t HRS01:1;
                vuint32_t HRS02:1;
                vuint32_t HRS03:1;
                vuint32_t HRS04:1;
                vuint32_t HRS05:1;
                vuint32_t HRS06:1;
                vuint32_t HRS07:1;
                vuint32_t HRS08:1;
                vuint32_t HRS09:1;
                vuint32_t HRS10:1;
                vuint32_t HRS11:1;
                vuint32_t HRS12:1;
                vuint32_t HRS13:1;
                vuint32_t HRS14:1;
                vuint32_t HRS15:1;
		vuint32_t HRS16:1;
                vuint32_t HRS17:1;
                vuint32_t HRS18:1;
                vuint32_t HRS19:1;
                vuint32_t HRS20:1;
                vuint32_t HRS21:1;
                vuint32_t HRS22:1;
                vuint32_t HRS23:1;
                vuint32_t HRS24:1;
                vuint32_t HRS25:1;
                vuint32_t HRS26:1;
                vuint32_t HRS27:1;
                vuint32_t HRS28:1;
                vuint32_t HRS29:1;
                vuint32_t HRS30:1;
                vuint32_t HRS31:1;
            } B;
        } HRSL;                         /* DMA Hardware Request Status Low */
  
  vuint8_t RESERVED5[200];
  
  union {
            vuint8_t R;
            struct {
                vuint8_t CHPRI:4;
                vuint8_t GRPPRI:2;
                vuint8_t DPA:1;
                vuint8_t ECP:1;
            } B;
        } CPR[32];
  
  //vuint8_t DCHPRI3;            /* offset: 0x00000100*/
  //vuint8_t DCHPRI2;            /* offset: 0x00000101*/
  //vuint8_t DCHPRI1;            /* offset: 0x00000102*/
  //vuint8_t DCHPRI0;            /* offset: 0x00000103*/ 
  //vuint8_t DCHPRI7;            /* offset: 0x00000104*/  
  //vuint8_t DCHPRI6;            /* offset: 0x00000105*/
  //vuint8_t DCHPRI5;            /* offset: 0x00000106*/
  //vuint8_t DCHPRI4;            /* offset: 0x00000107*/
  //vuint8_t DCHPRI11;           /* offset: 0x00000108*/
  //vuint8_t DCHPRI10;           /* offset: 0x00000109*/
  //vuint8_t DCHPRI9;            /* offset: 0x0000010A*/
  //vuint8_t DCHPRI8;            /* offset: 0x0000010B*/
  //vuint8_t DCHPRI15;           /* offset: 0x0000010C*/
  //vuint8_t DCHPRI14;           /* offset: 0x0000010D*/
  //vuint8_t DCHPRI13;           /* offset: 0x0000010E*/
  //vuint8_t DCHPRI12;           /* offset: 0x0000010F*/
  //vuint8_t DCHPRI19;           /* offset: 0x00000110*/
  //vuint8_t DCHPRI18;           /* offset: 0x00000111*/
  //vuint8_t DCHPRI17;           /* offset: 0x00000112*/
  //vuint8_t DCHPRI16;           /* offset: 0x00000113*/
  //vuint8_t DCHPRI23;           /* offset: 0x00000114*/
  //vuint8_t DCHPRI22;           /* offset: 0x00000115*/
  //vuint8_t DCHPRI21;           /* offset: 0x00000116*/
  //vuint8_t DCHPRI20;           /* offset: 0x00000117*/
  //vuint8_t DCHPRI27;           /* offset: 0x00000118*/
  //vuint8_t DCHPRI26;           /* offset: 0x00000119*/
  //vuint8_t DCHPRI25;           /* offset: 0x0000011A*/
  //vuint8_t DCHPRI24;           /* offset: 0x0000011B*/
  //vuint8_t DCHPRI31;           /* offset: 0x0000011C*/
  //vuint8_t DCHPRI30;           /* offset: 0x0000011D*/
  //vuint8_t DCHPRI29;           /* offset: 0x0000011E*/
  //vuint8_t DCHPRI28;           /* offset: 0x0000011F*/
  vuint8_t RESERVED6[3808];
  struct EDMA_TCD_STD_tag TCD[32];
};

/* DMA - Register offsets */
#define DMA_CR_OFFSET                  0x00000000
#define DMA_ES_OFFSET                  0x00000004
#define DMA_ERQ_OFFSET                 0x0000000C
#define DMA_EEI_OFFSET                 0x00000014
#define DMA_CEEI_OFFSET                0x00000018
#define DMA_SEEI_OFFSET                0x00000019
#define DMA_CERQ_OFFSET                0x0000001A
#define DMA_SERQ_OFFSET                0x0000001B
#define DMA_CDNE_OFFSET                0x0000001C
#define DMA_SSRT_OFFSET                0x0000001D
#define DMA_CERR_OFFSET                0x0000001E
#define DMA_CINT_OFFSET                0x0000001F
#define DMA_INT_OFFSET                 0x00000024
#define DMA_ERR_OFFSET                 0x0000002C
#define DMA_HRS_OFFSET                 0x00000034
#define DMA_DCHPRI3_OFFSET             0x00000100
#define DMA_DCHPRI2_OFFSET             0x00000101
#define DMA_DCHPRI1_OFFSET             0x00000102
#define DMA_DCHPRI0_OFFSET             0x00000103
#define DMA_DCHPRI7_OFFSET             0x00000104
#define DMA_DCHPRI6_OFFSET             0x00000105
#define DMA_DCHPRI5_OFFSET             0x00000106
#define DMA_DCHPRI4_OFFSET             0x00000107
#define DMA_DCHPRI11_OFFSET            0x00000108
#define DMA_DCHPRI10_OFFSET            0x00000109
#define DMA_DCHPRI9_OFFSET             0x0000010A
#define DMA_DCHPRI8_OFFSET             0x0000010B
#define DMA_DCHPRI15_OFFSET            0x0000010C
#define DMA_DCHPRI14_OFFSET            0x0000010D
#define DMA_DCHPRI13_OFFSET            0x0000010E
#define DMA_DCHPRI12_OFFSET            0x0000010F
#define DMA_DCHPRI19_OFFSET            0x00000110
#define DMA_DCHPRI18_OFFSET            0x00000111
#define DMA_DCHPRI17_OFFSET            0x00000112
#define DMA_DCHPRI16_OFFSET            0x00000113
#define DMA_DCHPRI23_OFFSET            0x00000114
#define DMA_DCHPRI22_OFFSET            0x00000115
#define DMA_DCHPRI21_OFFSET            0x00000116
#define DMA_DCHPRI20_OFFSET            0x00000117
#define DMA_DCHPRI27_OFFSET            0x00000118
#define DMA_DCHPRI26_OFFSET            0x00000119
#define DMA_DCHPRI25_OFFSET            0x0000011A
#define DMA_DCHPRI24_OFFSET            0x0000011B
#define DMA_DCHPRI31_OFFSET            0x0000011C
#define DMA_DCHPRI30_OFFSET            0x0000011D
#define DMA_DCHPRI29_OFFSET            0x0000011E
#define DMA_DCHPRI28_OFFSET            0x0000011F
#define DMA_TCD0_WORD0_OFFSET          0x00001000
#define DMA_TCD0_WORD1_OFFSET          0x00001004
#define DMA_TCD0_WORD2_OFFSET          0x00001008
#define DMA_TCD0_WORD3_OFFSET          0x0000100C
#define DMA_TCD0_WORD4_OFFSET          0x00001010
#define DMA_TCD0_WORD5_OFFSET          0x00001014
#define DMA_TCD0_WORD6_OFFSET          0x00001018
#define DMA_TCD0_WORD7_OFFSET          0x0000101C
#define DMA_TCD1_WORD0_OFFSET          0x00001020
#define DMA_TCD1_WORD1_OFFSET          0x00001024
#define DMA_TCD1_WORD2_OFFSET          0x00001028
#define DMA_TCD1_WORD3_OFFSET          0x0000102C
#define DMA_TCD1_WORD4_OFFSET          0x00001030
#define DMA_TCD1_WORD5_OFFSET          0x00001034
#define DMA_TCD1_WORD6_OFFSET          0x00001038
#define DMA_TCD1_WORD7_OFFSET          0x0000103C
#define DMA_TCD2_WORD0_OFFSET          0x00001040
#define DMA_TCD2_WORD1_OFFSET          0x00001044
#define DMA_TCD2_WORD2_OFFSET          0x00001048
#define DMA_TCD2_WORD3_OFFSET          0x0000104C
#define DMA_TCD2_WORD4_OFFSET          0x00001050
#define DMA_TCD2_WORD5_OFFSET          0x00001054
#define DMA_TCD2_WORD6_OFFSET          0x00001058
#define DMA_TCD2_WORD7_OFFSET          0x0000105C
#define DMA_TCD3_WORD0_OFFSET          0x00001060
#define DMA_TCD3_WORD1_OFFSET          0x00001064
#define DMA_TCD3_WORD2_OFFSET          0x00001068
#define DMA_TCD3_WORD3_OFFSET          0x0000106C
#define DMA_TCD3_WORD4_OFFSET          0x00001070
#define DMA_TCD3_WORD5_OFFSET          0x00001074
#define DMA_TCD3_WORD6_OFFSET          0x00001078
#define DMA_TCD3_WORD7_OFFSET          0x0000107C
#define DMA_TCD4_WORD0_OFFSET          0x00001080
#define DMA_TCD4_WORD1_OFFSET          0x00001084
#define DMA_TCD4_WORD2_OFFSET          0x00001088
#define DMA_TCD4_WORD3_OFFSET          0x0000108C
#define DMA_TCD4_WORD4_OFFSET          0x00001090
#define DMA_TCD4_WORD5_OFFSET          0x00001094
#define DMA_TCD4_WORD6_OFFSET          0x00001098
#define DMA_TCD4_WORD7_OFFSET          0x0000109C
#define DMA_TCD5_WORD0_OFFSET          0x000010A0
#define DMA_TCD5_WORD1_OFFSET          0x000010A4
#define DMA_TCD5_WORD2_OFFSET          0x000010A8
#define DMA_TCD5_WORD3_OFFSET          0x000010AC
#define DMA_TCD5_WORD4_OFFSET          0x000010B0
#define DMA_TCD5_WORD5_OFFSET          0x000010B4
#define DMA_TCD5_WORD6_OFFSET          0x000010B8
#define DMA_TCD5_WORD7_OFFSET          0x000010BC
#define DMA_TCD6_WORD0_OFFSET          0x000010C0
#define DMA_TCD6_WORD1_OFFSET          0x000010C4
#define DMA_TCD6_WORD2_OFFSET          0x000010C8
#define DMA_TCD6_WORD3_OFFSET          0x000010CC
#define DMA_TCD6_WORD4_OFFSET          0x000010D0
#define DMA_TCD6_WORD5_OFFSET          0x000010D4
#define DMA_TCD6_WORD6_OFFSET          0x000010D8
#define DMA_TCD6_WORD7_OFFSET          0x000010DC
#define DMA_TCD7_WORD0_OFFSET          0x000010E0
#define DMA_TCD7_WORD1_OFFSET          0x000010E4
#define DMA_TCD7_WORD2_OFFSET          0x000010E8
#define DMA_TCD7_WORD3_OFFSET          0x000010EC
#define DMA_TCD7_WORD4_OFFSET          0x000010F0
#define DMA_TCD7_WORD5_OFFSET          0x000010F4
#define DMA_TCD7_WORD6_OFFSET          0x000010F8
#define DMA_TCD7_WORD7_OFFSET          0x000010FC
#define DMA_TCD8_WORD0_OFFSET          0x00001100
#define DMA_TCD8_WORD1_OFFSET          0x00001104
#define DMA_TCD8_WORD2_OFFSET          0x00001108
#define DMA_TCD8_WORD3_OFFSET          0x0000110C
#define DMA_TCD8_WORD4_OFFSET          0x00001110
#define DMA_TCD8_WORD5_OFFSET          0x00001114
#define DMA_TCD8_WORD6_OFFSET          0x00001118
#define DMA_TCD8_WORD7_OFFSET          0x0000111C
#define DMA_TCD9_WORD0_OFFSET          0x00001120
#define DMA_TCD9_WORD1_OFFSET          0x00001124
#define DMA_TCD9_WORD2_OFFSET          0x00001128
#define DMA_TCD9_WORD3_OFFSET          0x0000112C
#define DMA_TCD9_WORD4_OFFSET          0x00001130
#define DMA_TCD9_WORD5_OFFSET          0x00001134
#define DMA_TCD9_WORD6_OFFSET          0x00001138
#define DMA_TCD9_WORD7_OFFSET          0x0000113C
#define DMA_TCD10_WORD0_OFFSET         0x00001140
#define DMA_TCD10_WORD1_OFFSET         0x00001144
#define DMA_TCD10_WORD2_OFFSET         0x00001148
#define DMA_TCD10_WORD3_OFFSET         0x0000114C
#define DMA_TCD10_WORD4_OFFSET         0x00001150
#define DMA_TCD10_WORD5_OFFSET         0x00001154
#define DMA_TCD10_WORD6_OFFSET         0x00001158
#define DMA_TCD10_WORD7_OFFSET         0x0000115C
#define DMA_TCD11_WORD0_OFFSET         0x00001160
#define DMA_TCD11_WORD1_OFFSET         0x00001164
#define DMA_TCD11_WORD2_OFFSET         0x00001168
#define DMA_TCD11_WORD3_OFFSET         0x0000116C
#define DMA_TCD11_WORD4_OFFSET         0x00001170
#define DMA_TCD11_WORD5_OFFSET         0x00001174
#define DMA_TCD11_WORD6_OFFSET         0x00001178
#define DMA_TCD11_WORD7_OFFSET         0x0000117C
#define DMA_TCD12_WORD0_OFFSET         0x00001180
#define DMA_TCD12_WORD1_OFFSET         0x00001184
#define DMA_TCD12_WORD2_OFFSET         0x00001188
#define DMA_TCD12_WORD3_OFFSET         0x0000118C
#define DMA_TCD12_WORD4_OFFSET         0x00001190
#define DMA_TCD12_WORD5_OFFSET         0x00001194
#define DMA_TCD12_WORD6_OFFSET         0x00001198
#define DMA_TCD12_WORD7_OFFSET         0x0000119C
#define DMA_TCD13_WORD0_OFFSET         0x000011A0
#define DMA_TCD13_WORD1_OFFSET         0x000011A4
#define DMA_TCD13_WORD2_OFFSET         0x000011A8
#define DMA_TCD13_WORD3_OFFSET         0x000011AC
#define DMA_TCD13_WORD4_OFFSET         0x000011B0
#define DMA_TCD13_WORD5_OFFSET         0x000011B4
#define DMA_TCD13_WORD6_OFFSET         0x000011B8
#define DMA_TCD13_WORD7_OFFSET         0x000011BC
#define DMA_TCD14_WORD0_OFFSET         0x000011C0
#define DMA_TCD14_WORD1_OFFSET         0x000011C4
#define DMA_TCD14_WORD2_OFFSET         0x000011C8
#define DMA_TCD14_WORD3_OFFSET         0x000011CC
#define DMA_TCD14_WORD4_OFFSET         0x000011D0
#define DMA_TCD14_WORD5_OFFSET         0x000011D4
#define DMA_TCD14_WORD6_OFFSET         0x000011D8
#define DMA_TCD14_WORD7_OFFSET         0x000011DC
#define DMA_TCD15_WORD0_OFFSET         0x000011E0
#define DMA_TCD15_WORD1_OFFSET         0x000011E4
#define DMA_TCD15_WORD2_OFFSET         0x000011E8
#define DMA_TCD15_WORD3_OFFSET         0x000011EC
#define DMA_TCD15_WORD4_OFFSET         0x000011F0
#define DMA_TCD15_WORD5_OFFSET         0x000011F4
#define DMA_TCD15_WORD6_OFFSET         0x000011F8
#define DMA_TCD15_WORD7_OFFSET         0x000011FC
#define DMA_TCD16_WORD0_OFFSET         0x00001200
#define DMA_TCD16_WORD1_OFFSET         0x00001204
#define DMA_TCD16_WORD2_OFFSET         0x00001208
#define DMA_TCD16_WORD3_OFFSET         0x0000120C
#define DMA_TCD16_WORD4_OFFSET         0x00001210
#define DMA_TCD16_WORD5_OFFSET         0x00001214
#define DMA_TCD16_WORD6_OFFSET         0x00001218
#define DMA_TCD16_WORD7_OFFSET         0x0000121C
#define DMA_TCD17_WORD0_OFFSET         0x00001220
#define DMA_TCD17_WORD1_OFFSET         0x00001224
#define DMA_TCD17_WORD2_OFFSET         0x00001228
#define DMA_TCD17_WORD3_OFFSET         0x0000122C
#define DMA_TCD17_WORD4_OFFSET         0x00001230
#define DMA_TCD17_WORD5_OFFSET         0x00001234
#define DMA_TCD17_WORD6_OFFSET         0x00001238
#define DMA_TCD17_WORD7_OFFSET         0x0000123C
#define DMA_TCD18_WORD0_OFFSET         0x00001240
#define DMA_TCD18_WORD1_OFFSET         0x00001244
#define DMA_TCD18_WORD2_OFFSET         0x00001248
#define DMA_TCD18_WORD3_OFFSET         0x0000124C
#define DMA_TCD18_WORD4_OFFSET         0x00001250
#define DMA_TCD18_WORD5_OFFSET         0x00001254
#define DMA_TCD18_WORD6_OFFSET         0x00001258
#define DMA_TCD18_WORD7_OFFSET         0x0000125C
#define DMA_TCD19_WORD0_OFFSET         0x00001260
#define DMA_TCD19_WORD1_OFFSET         0x00001264
#define DMA_TCD19_WORD2_OFFSET         0x00001268
#define DMA_TCD19_WORD3_OFFSET         0x0000126C
#define DMA_TCD19_WORD4_OFFSET         0x00001270
#define DMA_TCD19_WORD5_OFFSET         0x00001274
#define DMA_TCD19_WORD6_OFFSET         0x00001278
#define DMA_TCD19_WORD7_OFFSET         0x0000127C
#define DMA_TCD20_WORD0_OFFSET         0x00001280
#define DMA_TCD20_WORD1_OFFSET         0x00001284
#define DMA_TCD20_WORD2_OFFSET         0x00001288
#define DMA_TCD20_WORD3_OFFSET         0x0000128C
#define DMA_TCD20_WORD4_OFFSET         0x00001290
#define DMA_TCD20_WORD5_OFFSET         0x00001294
#define DMA_TCD20_WORD6_OFFSET         0x00001298
#define DMA_TCD20_WORD7_OFFSET         0x0000129C
#define DMA_TCD21_WORD0_OFFSET         0x000012A0
#define DMA_TCD21_WORD1_OFFSET         0x000012A4
#define DMA_TCD21_WORD2_OFFSET         0x000012A8
#define DMA_TCD21_WORD3_OFFSET         0x000012AC
#define DMA_TCD21_WORD4_OFFSET         0x000012B0
#define DMA_TCD21_WORD5_OFFSET         0x000012B4
#define DMA_TCD21_WORD6_OFFSET         0x000012B8
#define DMA_TCD21_WORD7_OFFSET         0x000012BC
#define DMA_TCD22_WORD0_OFFSET         0x000012C0
#define DMA_TCD22_WORD1_OFFSET         0x000012C4
#define DMA_TCD22_WORD2_OFFSET         0x000012C8
#define DMA_TCD22_WORD3_OFFSET         0x000012CC
#define DMA_TCD22_WORD4_OFFSET         0x000012D0
#define DMA_TCD22_WORD5_OFFSET         0x000012D4
#define DMA_TCD22_WORD6_OFFSET         0x000012D8
#define DMA_TCD22_WORD7_OFFSET         0x000012DC
#define DMA_TCD23_WORD0_OFFSET         0x000012E0
#define DMA_TCD23_WORD1_OFFSET         0x000012E4
#define DMA_TCD23_WORD2_OFFSET         0x000012E8
#define DMA_TCD23_WORD3_OFFSET         0x000012EC
#define DMA_TCD23_WORD4_OFFSET         0x000012F0
#define DMA_TCD23_WORD5_OFFSET         0x000012F4
#define DMA_TCD23_WORD6_OFFSET         0x000012F8
#define DMA_TCD23_WORD7_OFFSET         0x000012FC
#define DMA_TCD24_WORD0_OFFSET         0x00001300
#define DMA_TCD24_WORD1_OFFSET         0x00001304
#define DMA_TCD24_WORD2_OFFSET         0x00001308
#define DMA_TCD24_WORD3_OFFSET         0x0000130C
#define DMA_TCD24_WORD4_OFFSET         0x00001310
#define DMA_TCD24_WORD5_OFFSET         0x00001314
#define DMA_TCD24_WORD6_OFFSET         0x00001318
#define DMA_TCD24_WORD7_OFFSET         0x0000131C
#define DMA_TCD25_WORD0_OFFSET         0x00001320
#define DMA_TCD25_WORD1_OFFSET         0x00001324
#define DMA_TCD25_WORD2_OFFSET         0x00001328
#define DMA_TCD25_WORD3_OFFSET         0x0000132C
#define DMA_TCD25_WORD4_OFFSET         0x00001330
#define DMA_TCD25_WORD5_OFFSET         0x00001334
#define DMA_TCD25_WORD6_OFFSET         0x00001338
#define DMA_TCD25_WORD7_OFFSET         0x0000133C
#define DMA_TCD26_WORD0_OFFSET         0x00001340
#define DMA_TCD26_WORD1_OFFSET         0x00001344
#define DMA_TCD26_WORD2_OFFSET         0x00001348
#define DMA_TCD26_WORD3_OFFSET         0x0000134C
#define DMA_TCD26_WORD4_OFFSET         0x00001350
#define DMA_TCD26_WORD5_OFFSET         0x00001354
#define DMA_TCD26_WORD6_OFFSET         0x00001358
#define DMA_TCD26_WORD7_OFFSET         0x0000135C
#define DMA_TCD27_WORD0_OFFSET         0x00001360
#define DMA_TCD27_WORD1_OFFSET         0x00001364
#define DMA_TCD27_WORD2_OFFSET         0x00001368
#define DMA_TCD27_WORD3_OFFSET         0x0000136C
#define DMA_TCD27_WORD4_OFFSET         0x00001370
#define DMA_TCD27_WORD5_OFFSET         0x00001374
#define DMA_TCD27_WORD6_OFFSET         0x00001378
#define DMA_TCD27_WORD7_OFFSET         0x0000137C
#define DMA_TCD28_WORD0_OFFSET         0x00001380
#define DMA_TCD28_WORD1_OFFSET         0x00001384
#define DMA_TCD28_WORD2_OFFSET         0x00001388
#define DMA_TCD28_WORD3_OFFSET         0x0000138C
#define DMA_TCD28_WORD4_OFFSET         0x00001390
#define DMA_TCD28_WORD5_OFFSET         0x00001394
#define DMA_TCD28_WORD6_OFFSET         0x00001398
#define DMA_TCD28_WORD7_OFFSET         0x0000139C
#define DMA_TCD29_WORD0_OFFSET         0x000013A0
#define DMA_TCD29_WORD1_OFFSET         0x000013A4
#define DMA_TCD29_WORD2_OFFSET         0x000013A8
#define DMA_TCD29_WORD3_OFFSET         0x000013AC
#define DMA_TCD29_WORD4_OFFSET         0x000013B0
#define DMA_TCD29_WORD5_OFFSET         0x000013B4
#define DMA_TCD29_WORD6_OFFSET         0x000013B8
#define DMA_TCD29_WORD7_OFFSET         0x000013BC
#define DMA_TCD30_WORD0_OFFSET         0x000013C0
#define DMA_TCD30_WORD1_OFFSET         0x000013C4
#define DMA_TCD30_WORD2_OFFSET         0x000013C8
#define DMA_TCD30_WORD3_OFFSET         0x000013CC
#define DMA_TCD30_WORD4_OFFSET         0x000013D0
#define DMA_TCD30_WORD5_OFFSET         0x000013D4
#define DMA_TCD30_WORD6_OFFSET         0x000013D8
#define DMA_TCD30_WORD7_OFFSET         0x000013DC
#define DMA_TCD31_WORD0_OFFSET         0x000013E0
#define DMA_TCD31_WORD1_OFFSET         0x000013E4
#define DMA_TCD31_WORD2_OFFSET         0x000013E8
#define DMA_TCD31_WORD3_OFFSET         0x000013EC
#define DMA_TCD31_WORD4_OFFSET         0x000013F0
#define DMA_TCD31_WORD5_OFFSET         0x000013F4
#define DMA_TCD31_WORD6_OFFSET         0x000013F8
#define DMA_TCD31_WORD7_OFFSET         0x000013FC

/* DMA Register per module */
#define DMA0_CR                          (DMA0_BASE + DMA_CR_OFFSET)
#define DMA0_ES                          (DMA0_BASE + DMA_ES_OFFSET)
#define DMA0_ERQ                         (DMA0_BASE + DMA_ERQ_OFFSET)
#define DMA0_EEI                         (DMA0_BASE + DMA_EEI_OFFSET)
#define DMA0_CEEI                        (DMA0_BASE + DMA_CEEI_OFFSET)
#define DMA0_SEEI                        (DMA0_BASE + DMA_SEEI_OFFSET)
#define DMA0_CERQ                        (DMA0_BASE + DMA_CERQ_OFFSET)
#define DMA0_SERQ                        (DMA0_BASE + DMA_SERQ_OFFSET)
#define DMA0_CDNE                        (DMA0_BASE + DMA_CDNE_OFFSET)
#define DMA0_SSRT                        (DMA0_BASE + DMA_SSRT_OFFSET)
#define DMA0_CERR                        (DMA0_BASE + DMA_CERR_OFFSET)
#define DMA0_CINT                        (DMA0_BASE + DMA_CINT_OFFSET)
#define DMA0_INT                         (DMA0_BASE + DMA_INT_OFFSET)
#define DMA0_ERR                         (DMA0_BASE + DMA_ERR_OFFSET)
#define DMA0_HRS                         (DMA0_BASE + DMA_HRS_OFFSET)
#define DMA0_DCHPRI3                     (DMA0_BASE + DMA_DCHPRI3_OFFSET)
#define DMA0_DCHPRI2                     (DMA0_BASE + DMA_DCHPRI2_OFFSET)
#define DMA0_DCHPRI1                     (DMA0_BASE + DMA_DCHPRI1_OFFSET)
#define DMA0_DCHPRI0                     (DMA0_BASE + DMA_DCHPRI0_OFFSET)
#define DMA0_DCHPRI7                     (DMA0_BASE + DMA_DCHPRI7_OFFSET)
#define DMA0_DCHPRI6                     (DMA0_BASE + DMA_DCHPRI6_OFFSET)
#define DMA0_DCHPRI5                     (DMA0_BASE + DMA_DCHPRI5_OFFSET)
#define DMA0_DCHPRI4                     (DMA0_BASE + DMA_DCHPRI4_OFFSET)
#define DMA0_DCHPRI11                    (DMA0_BASE + DMA_DCHPRI11_OFFSET)
#define DMA0_DCHPRI10                    (DMA0_BASE + DMA_DCHPRI10_OFFSET)
#define DMA0_DCHPRI9                     (DMA0_BASE + DMA_DCHPRI9_OFFSET)
#define DMA0_DCHPRI8                     (DMA0_BASE + DMA_DCHPRI8_OFFSET)
#define DMA0_DCHPRI15                    (DMA0_BASE + DMA_DCHPRI15_OFFSET)
#define DMA0_DCHPRI14                    (DMA0_BASE + DMA_DCHPRI14_OFFSET)
#define DMA0_DCHPRI13                    (DMA0_BASE + DMA_DCHPRI13_OFFSET)
#define DMA0_DCHPRI12                    (DMA0_BASE + DMA_DCHPRI12_OFFSET)
#define DMA0_DCHPRI19                    (DMA0_BASE + DMA_DCHPRI19_OFFSET)
#define DMA0_DCHPRI18                    (DMA0_BASE + DMA_DCHPRI18_OFFSET)
#define DMA0_DCHPRI17                    (DMA0_BASE + DMA_DCHPRI17_OFFSET)
#define DMA0_DCHPRI16                    (DMA0_BASE + DMA_DCHPRI16_OFFSET)
#define DMA0_DCHPRI23                    (DMA0_BASE + DMA_DCHPRI23_OFFSET)
#define DMA0_DCHPRI22                    (DMA0_BASE + DMA_DCHPRI22_OFFSET)
#define DMA0_DCHPRI21                    (DMA0_BASE + DMA_DCHPRI21_OFFSET)
#define DMA0_DCHPRI20                    (DMA0_BASE + DMA_DCHPRI20_OFFSET)
#define DMA0_DCHPRI27                    (DMA0_BASE + DMA_DCHPRI27_OFFSET)
#define DMA0_DCHPRI26                    (DMA0_BASE + DMA_DCHPRI26_OFFSET)
#define DMA0_DCHPRI25                    (DMA0_BASE + DMA_DCHPRI25_OFFSET)
#define DMA0_DCHPRI24                    (DMA0_BASE + DMA_DCHPRI24_OFFSET)
#define DMA0_DCHPRI31                    (DMA0_BASE + DMA_DCHPRI31_OFFSET)
#define DMA0_DCHPRI30                    (DMA0_BASE + DMA_DCHPRI30_OFFSET)
#define DMA0_DCHPRI29                    (DMA0_BASE + DMA_DCHPRI29_OFFSET)
#define DMA0_DCHPRI28                    (DMA0_BASE + DMA_DCHPRI28_OFFSET)
#define DMA0_TCD0_WORD0                  (DMA0_BASE + DMA_TCD0_WORD0_OFFSET)
#define DMA0_TCD0_WORD1                  (DMA0_BASE + DMA_TCD0_WORD1_OFFSET)
#define DMA0_TCD0_WORD2                  (DMA0_BASE + DMA_TCD0_WORD2_OFFSET)
#define DMA0_TCD0_WORD3                  (DMA0_BASE + DMA_TCD0_WORD3_OFFSET)
#define DMA0_TCD0_WORD4                  (DMA0_BASE + DMA_TCD0_WORD4_OFFSET)
#define DMA0_TCD0_WORD5                  (DMA0_BASE + DMA_TCD0_WORD5_OFFSET)
#define DMA0_TCD0_WORD6                  (DMA0_BASE + DMA_TCD0_WORD6_OFFSET)
#define DMA0_TCD0_WORD7                  (DMA0_BASE + DMA_TCD0_WORD7_OFFSET)
#define DMA0_TCD1_WORD0                  (DMA0_BASE + DMA_TCD1_WORD0_OFFSET)
#define DMA0_TCD1_WORD1                  (DMA0_BASE + DMA_TCD1_WORD1_OFFSET)
#define DMA0_TCD1_WORD2                  (DMA0_BASE + DMA_TCD1_WORD2_OFFSET)
#define DMA0_TCD1_WORD3                  (DMA0_BASE + DMA_TCD1_WORD3_OFFSET)
#define DMA0_TCD1_WORD4                  (DMA0_BASE + DMA_TCD1_WORD4_OFFSET)
#define DMA0_TCD1_WORD5                  (DMA0_BASE + DMA_TCD1_WORD5_OFFSET)
#define DMA0_TCD1_WORD6                  (DMA0_BASE + DMA_TCD1_WORD6_OFFSET)
#define DMA0_TCD1_WORD7                  (DMA0_BASE + DMA_TCD1_WORD7_OFFSET)
#define DMA0_TCD2_WORD0                  (DMA0_BASE + DMA_TCD2_WORD0_OFFSET)
#define DMA0_TCD2_WORD1                  (DMA0_BASE + DMA_TCD2_WORD1_OFFSET)
#define DMA0_TCD2_WORD2                  (DMA0_BASE + DMA_TCD2_WORD2_OFFSET)
#define DMA0_TCD2_WORD3                  (DMA0_BASE + DMA_TCD2_WORD3_OFFSET)
#define DMA0_TCD2_WORD4                  (DMA0_BASE + DMA_TCD2_WORD4_OFFSET)
#define DMA0_TCD2_WORD5                  (DMA0_BASE + DMA_TCD2_WORD5_OFFSET)
#define DMA0_TCD2_WORD6                  (DMA0_BASE + DMA_TCD2_WORD6_OFFSET)
#define DMA0_TCD2_WORD7                  (DMA0_BASE + DMA_TCD2_WORD7_OFFSET)
#define DMA0_TCD3_WORD0                  (DMA0_BASE + DMA_TCD3_WORD0_OFFSET)
#define DMA0_TCD3_WORD1                  (DMA0_BASE + DMA_TCD3_WORD1_OFFSET)
#define DMA0_TCD3_WORD2                  (DMA0_BASE + DMA_TCD3_WORD2_OFFSET)
#define DMA0_TCD3_WORD3                  (DMA0_BASE + DMA_TCD3_WORD3_OFFSET)
#define DMA0_TCD3_WORD4                  (DMA0_BASE + DMA_TCD3_WORD4_OFFSET)
#define DMA0_TCD3_WORD5                  (DMA0_BASE + DMA_TCD3_WORD5_OFFSET)
#define DMA0_TCD3_WORD6                  (DMA0_BASE + DMA_TCD3_WORD6_OFFSET)
#define DMA0_TCD3_WORD7                  (DMA0_BASE + DMA_TCD3_WORD7_OFFSET)
#define DMA0_TCD4_WORD0                  (DMA0_BASE + DMA_TCD4_WORD0_OFFSET)
#define DMA0_TCD4_WORD1                  (DMA0_BASE + DMA_TCD4_WORD1_OFFSET)
#define DMA0_TCD4_WORD2                  (DMA0_BASE + DMA_TCD4_WORD2_OFFSET)
#define DMA0_TCD4_WORD3                  (DMA0_BASE + DMA_TCD4_WORD3_OFFSET)
#define DMA0_TCD4_WORD4                  (DMA0_BASE + DMA_TCD4_WORD4_OFFSET)
#define DMA0_TCD4_WORD5                  (DMA0_BASE + DMA_TCD4_WORD5_OFFSET)
#define DMA0_TCD4_WORD6                  (DMA0_BASE + DMA_TCD4_WORD6_OFFSET)
#define DMA0_TCD4_WORD7                  (DMA0_BASE + DMA_TCD4_WORD7_OFFSET)
#define DMA0_TCD5_WORD0                  (DMA0_BASE + DMA_TCD5_WORD0_OFFSET)
#define DMA0_TCD5_WORD1                  (DMA0_BASE + DMA_TCD5_WORD1_OFFSET)
#define DMA0_TCD5_WORD2                  (DMA0_BASE + DMA_TCD5_WORD2_OFFSET)
#define DMA0_TCD5_WORD3                  (DMA0_BASE + DMA_TCD5_WORD3_OFFSET)
#define DMA0_TCD5_WORD4                  (DMA0_BASE + DMA_TCD5_WORD4_OFFSET)
#define DMA0_TCD5_WORD5                  (DMA0_BASE + DMA_TCD5_WORD5_OFFSET)
#define DMA0_TCD5_WORD6                  (DMA0_BASE + DMA_TCD5_WORD6_OFFSET)
#define DMA0_TCD5_WORD7                  (DMA0_BASE + DMA_TCD5_WORD7_OFFSET)
#define DMA0_TCD6_WORD0                  (DMA0_BASE + DMA_TCD6_WORD0_OFFSET)
#define DMA0_TCD6_WORD1                  (DMA0_BASE + DMA_TCD6_WORD1_OFFSET)
#define DMA0_TCD6_WORD2                  (DMA0_BASE + DMA_TCD6_WORD2_OFFSET)
#define DMA0_TCD6_WORD3                  (DMA0_BASE + DMA_TCD6_WORD3_OFFSET)
#define DMA0_TCD6_WORD4                  (DMA0_BASE + DMA_TCD6_WORD4_OFFSET)
#define DMA0_TCD6_WORD5                  (DMA0_BASE + DMA_TCD6_WORD5_OFFSET)
#define DMA0_TCD6_WORD6                  (DMA0_BASE + DMA_TCD6_WORD6_OFFSET)
#define DMA0_TCD6_WORD7                  (DMA0_BASE + DMA_TCD6_WORD7_OFFSET)
#define DMA0_TCD7_WORD0                  (DMA0_BASE + DMA_TCD7_WORD0_OFFSET)
#define DMA0_TCD7_WORD1                  (DMA0_BASE + DMA_TCD7_WORD1_OFFSET)
#define DMA0_TCD7_WORD2                  (DMA0_BASE + DMA_TCD7_WORD2_OFFSET)
#define DMA0_TCD7_WORD3                  (DMA0_BASE + DMA_TCD7_WORD3_OFFSET)
#define DMA0_TCD7_WORD4                  (DMA0_BASE + DMA_TCD7_WORD4_OFFSET)
#define DMA0_TCD7_WORD5                  (DMA0_BASE + DMA_TCD7_WORD5_OFFSET)
#define DMA0_TCD7_WORD6                  (DMA0_BASE + DMA_TCD7_WORD6_OFFSET)
#define DMA0_TCD7_WORD7                  (DMA0_BASE + DMA_TCD7_WORD7_OFFSET)
#define DMA0_TCD8_WORD0                  (DMA0_BASE + DMA_TCD8_WORD0_OFFSET)
#define DMA0_TCD8_WORD1                  (DMA0_BASE + DMA_TCD8_WORD1_OFFSET)
#define DMA0_TCD8_WORD2                  (DMA0_BASE + DMA_TCD8_WORD2_OFFSET)
#define DMA0_TCD8_WORD3                  (DMA0_BASE + DMA_TCD8_WORD3_OFFSET)
#define DMA0_TCD8_WORD4                  (DMA0_BASE + DMA_TCD8_WORD4_OFFSET)
#define DMA0_TCD8_WORD5                  (DMA0_BASE + DMA_TCD8_WORD5_OFFSET)
#define DMA0_TCD8_WORD6                  (DMA0_BASE + DMA_TCD8_WORD6_OFFSET)
#define DMA0_TCD8_WORD7                  (DMA0_BASE + DMA_TCD8_WORD7_OFFSET)
#define DMA0_TCD9_WORD0                  (DMA0_BASE + DMA_TCD9_WORD0_OFFSET)
#define DMA0_TCD9_WORD1                  (DMA0_BASE + DMA_TCD9_WORD1_OFFSET)
#define DMA0_TCD9_WORD2                  (DMA0_BASE + DMA_TCD9_WORD2_OFFSET)
#define DMA0_TCD9_WORD3                  (DMA0_BASE + DMA_TCD9_WORD3_OFFSET)
#define DMA0_TCD9_WORD4                  (DMA0_BASE + DMA_TCD9_WORD4_OFFSET)
#define DMA0_TCD9_WORD5                  (DMA0_BASE + DMA_TCD9_WORD5_OFFSET)
#define DMA0_TCD9_WORD6                  (DMA0_BASE + DMA_TCD9_WORD6_OFFSET)
#define DMA0_TCD9_WORD7                  (DMA0_BASE + DMA_TCD9_WORD7_OFFSET)
#define DMA0_TCD10_WORD0                 (DMA0_BASE + DMA_TCD10_WORD0_OFFSET)
#define DMA0_TCD10_WORD1                 (DMA0_BASE + DMA_TCD10_WORD1_OFFSET)
#define DMA0_TCD10_WORD2                 (DMA0_BASE + DMA_TCD10_WORD2_OFFSET)
#define DMA0_TCD10_WORD3                 (DMA0_BASE + DMA_TCD10_WORD3_OFFSET)
#define DMA0_TCD10_WORD4                 (DMA0_BASE + DMA_TCD10_WORD4_OFFSET)
#define DMA0_TCD10_WORD5                 (DMA0_BASE + DMA_TCD10_WORD5_OFFSET)
#define DMA0_TCD10_WORD6                 (DMA0_BASE + DMA_TCD10_WORD6_OFFSET)
#define DMA0_TCD10_WORD7                 (DMA0_BASE + DMA_TCD10_WORD7_OFFSET)
#define DMA0_TCD11_WORD0                 (DMA0_BASE + DMA_TCD11_WORD0_OFFSET)
#define DMA0_TCD11_WORD1                 (DMA0_BASE + DMA_TCD11_WORD1_OFFSET)
#define DMA0_TCD11_WORD2                 (DMA0_BASE + DMA_TCD11_WORD2_OFFSET)
#define DMA0_TCD11_WORD3                 (DMA0_BASE + DMA_TCD11_WORD3_OFFSET)
#define DMA0_TCD11_WORD4                 (DMA0_BASE + DMA_TCD11_WORD4_OFFSET)
#define DMA0_TCD11_WORD5                 (DMA0_BASE + DMA_TCD11_WORD5_OFFSET)
#define DMA0_TCD11_WORD6                 (DMA0_BASE + DMA_TCD11_WORD6_OFFSET)
#define DMA0_TCD11_WORD7                 (DMA0_BASE + DMA_TCD11_WORD7_OFFSET)
#define DMA0_TCD12_WORD0                 (DMA0_BASE + DMA_TCD12_WORD0_OFFSET)
#define DMA0_TCD12_WORD1                 (DMA0_BASE + DMA_TCD12_WORD1_OFFSET)
#define DMA0_TCD12_WORD2                 (DMA0_BASE + DMA_TCD12_WORD2_OFFSET)
#define DMA0_TCD12_WORD3                 (DMA0_BASE + DMA_TCD12_WORD3_OFFSET)
#define DMA0_TCD12_WORD4                 (DMA0_BASE + DMA_TCD12_WORD4_OFFSET)
#define DMA0_TCD12_WORD5                 (DMA0_BASE + DMA_TCD12_WORD5_OFFSET)
#define DMA0_TCD12_WORD6                 (DMA0_BASE + DMA_TCD12_WORD6_OFFSET)
#define DMA0_TCD12_WORD7                 (DMA0_BASE + DMA_TCD12_WORD7_OFFSET)
#define DMA0_TCD13_WORD0                 (DMA0_BASE + DMA_TCD13_WORD0_OFFSET)
#define DMA0_TCD13_WORD1                 (DMA0_BASE + DMA_TCD13_WORD1_OFFSET)
#define DMA0_TCD13_WORD2                 (DMA0_BASE + DMA_TCD13_WORD2_OFFSET)
#define DMA0_TCD13_WORD3                 (DMA0_BASE + DMA_TCD13_WORD3_OFFSET)
#define DMA0_TCD13_WORD4                 (DMA0_BASE + DMA_TCD13_WORD4_OFFSET)
#define DMA0_TCD13_WORD5                 (DMA0_BASE + DMA_TCD13_WORD5_OFFSET)
#define DMA0_TCD13_WORD6                 (DMA0_BASE + DMA_TCD13_WORD6_OFFSET)
#define DMA0_TCD13_WORD7                 (DMA0_BASE + DMA_TCD13_WORD7_OFFSET)
#define DMA0_TCD14_WORD0                 (DMA0_BASE + DMA_TCD14_WORD0_OFFSET)
#define DMA0_TCD14_WORD1                 (DMA0_BASE + DMA_TCD14_WORD1_OFFSET)
#define DMA0_TCD14_WORD2                 (DMA0_BASE + DMA_TCD14_WORD2_OFFSET)
#define DMA0_TCD14_WORD3                 (DMA0_BASE + DMA_TCD14_WORD3_OFFSET)
#define DMA0_TCD14_WORD4                 (DMA0_BASE + DMA_TCD14_WORD4_OFFSET)
#define DMA0_TCD14_WORD5                 (DMA0_BASE + DMA_TCD14_WORD5_OFFSET)
#define DMA0_TCD14_WORD6                 (DMA0_BASE + DMA_TCD14_WORD6_OFFSET)
#define DMA0_TCD14_WORD7                 (DMA0_BASE + DMA_TCD14_WORD7_OFFSET)
#define DMA0_TCD15_WORD0                 (DMA0_BASE + DMA_TCD15_WORD0_OFFSET)
#define DMA0_TCD15_WORD1                 (DMA0_BASE + DMA_TCD15_WORD1_OFFSET)
#define DMA0_TCD15_WORD2                 (DMA0_BASE + DMA_TCD15_WORD2_OFFSET)
#define DMA0_TCD15_WORD3                 (DMA0_BASE + DMA_TCD15_WORD3_OFFSET)
#define DMA0_TCD15_WORD4                 (DMA0_BASE + DMA_TCD15_WORD4_OFFSET)
#define DMA0_TCD15_WORD5                 (DMA0_BASE + DMA_TCD15_WORD5_OFFSET)
#define DMA0_TCD15_WORD6                 (DMA0_BASE + DMA_TCD15_WORD6_OFFSET)
#define DMA0_TCD15_WORD7                 (DMA0_BASE + DMA_TCD15_WORD7_OFFSET)
#define DMA0_TCD16_WORD0                 (DMA0_BASE + DMA_TCD16_WORD0_OFFSET)
#define DMA0_TCD16_WORD1                 (DMA0_BASE + DMA_TCD16_WORD1_OFFSET)
#define DMA0_TCD16_WORD2                 (DMA0_BASE + DMA_TCD16_WORD2_OFFSET)
#define DMA0_TCD16_WORD3                 (DMA0_BASE + DMA_TCD16_WORD3_OFFSET)
#define DMA0_TCD16_WORD4                 (DMA0_BASE + DMA_TCD16_WORD4_OFFSET)
#define DMA0_TCD16_WORD5                 (DMA0_BASE + DMA_TCD16_WORD5_OFFSET)
#define DMA0_TCD16_WORD6                 (DMA0_BASE + DMA_TCD16_WORD6_OFFSET)
#define DMA0_TCD16_WORD7                 (DMA0_BASE + DMA_TCD16_WORD7_OFFSET)
#define DMA0_TCD17_WORD0                 (DMA0_BASE + DMA_TCD17_WORD0_OFFSET)
#define DMA0_TCD17_WORD1                 (DMA0_BASE + DMA_TCD17_WORD1_OFFSET)
#define DMA0_TCD17_WORD2                 (DMA0_BASE + DMA_TCD17_WORD2_OFFSET)
#define DMA0_TCD17_WORD3                 (DMA0_BASE + DMA_TCD17_WORD3_OFFSET)
#define DMA0_TCD17_WORD4                 (DMA0_BASE + DMA_TCD17_WORD4_OFFSET)
#define DMA0_TCD17_WORD5                 (DMA0_BASE + DMA_TCD17_WORD5_OFFSET)
#define DMA0_TCD17_WORD6                 (DMA0_BASE + DMA_TCD17_WORD6_OFFSET)
#define DMA0_TCD17_WORD7                 (DMA0_BASE + DMA_TCD17_WORD7_OFFSET)
#define DMA0_TCD18_WORD0                 (DMA0_BASE + DMA_TCD18_WORD0_OFFSET)
#define DMA0_TCD18_WORD1                 (DMA0_BASE + DMA_TCD18_WORD1_OFFSET)
#define DMA0_TCD18_WORD2                 (DMA0_BASE + DMA_TCD18_WORD2_OFFSET)
#define DMA0_TCD18_WORD3                 (DMA0_BASE + DMA_TCD18_WORD3_OFFSET)
#define DMA0_TCD18_WORD4                 (DMA0_BASE + DMA_TCD18_WORD4_OFFSET)
#define DMA0_TCD18_WORD5                 (DMA0_BASE + DMA_TCD18_WORD5_OFFSET)
#define DMA0_TCD18_WORD6                 (DMA0_BASE + DMA_TCD18_WORD6_OFFSET)
#define DMA0_TCD18_WORD7                 (DMA0_BASE + DMA_TCD18_WORD7_OFFSET)
#define DMA0_TCD19_WORD0                 (DMA0_BASE + DMA_TCD19_WORD0_OFFSET)
#define DMA0_TCD19_WORD1                 (DMA0_BASE + DMA_TCD19_WORD1_OFFSET)
#define DMA0_TCD19_WORD2                 (DMA0_BASE + DMA_TCD19_WORD2_OFFSET)
#define DMA0_TCD19_WORD3                 (DMA0_BASE + DMA_TCD19_WORD3_OFFSET)
#define DMA0_TCD19_WORD4                 (DMA0_BASE + DMA_TCD19_WORD4_OFFSET)
#define DMA0_TCD19_WORD5                 (DMA0_BASE + DMA_TCD19_WORD5_OFFSET)
#define DMA0_TCD19_WORD6                 (DMA0_BASE + DMA_TCD19_WORD6_OFFSET)
#define DMA0_TCD19_WORD7                 (DMA0_BASE + DMA_TCD19_WORD7_OFFSET)
#define DMA0_TCD20_WORD0                 (DMA0_BASE + DMA_TCD20_WORD0_OFFSET)
#define DMA0_TCD20_WORD1                 (DMA0_BASE + DMA_TCD20_WORD1_OFFSET)
#define DMA0_TCD20_WORD2                 (DMA0_BASE + DMA_TCD20_WORD2_OFFSET)
#define DMA0_TCD20_WORD3                 (DMA0_BASE + DMA_TCD20_WORD3_OFFSET)
#define DMA0_TCD20_WORD4                 (DMA0_BASE + DMA_TCD20_WORD4_OFFSET)
#define DMA0_TCD20_WORD5                 (DMA0_BASE + DMA_TCD20_WORD5_OFFSET)
#define DMA0_TCD20_WORD6                 (DMA0_BASE + DMA_TCD20_WORD6_OFFSET)
#define DMA0_TCD20_WORD7                 (DMA0_BASE + DMA_TCD20_WORD7_OFFSET)
#define DMA0_TCD21_WORD0                 (DMA0_BASE + DMA_TCD21_WORD0_OFFSET)
#define DMA0_TCD21_WORD1                 (DMA0_BASE + DMA_TCD21_WORD1_OFFSET)
#define DMA0_TCD21_WORD2                 (DMA0_BASE + DMA_TCD21_WORD2_OFFSET)
#define DMA0_TCD21_WORD3                 (DMA0_BASE + DMA_TCD21_WORD3_OFFSET)
#define DMA0_TCD21_WORD4                 (DMA0_BASE + DMA_TCD21_WORD4_OFFSET)
#define DMA0_TCD21_WORD5                 (DMA0_BASE + DMA_TCD21_WORD5_OFFSET)
#define DMA0_TCD21_WORD6                 (DMA0_BASE + DMA_TCD21_WORD6_OFFSET)
#define DMA0_TCD21_WORD7                 (DMA0_BASE + DMA_TCD21_WORD7_OFFSET)
#define DMA0_TCD22_WORD0                 (DMA0_BASE + DMA_TCD22_WORD0_OFFSET)
#define DMA0_TCD22_WORD1                 (DMA0_BASE + DMA_TCD22_WORD1_OFFSET)
#define DMA0_TCD22_WORD2                 (DMA0_BASE + DMA_TCD22_WORD2_OFFSET)
#define DMA0_TCD22_WORD3                 (DMA0_BASE + DMA_TCD22_WORD3_OFFSET)
#define DMA0_TCD22_WORD4                 (DMA0_BASE + DMA_TCD22_WORD4_OFFSET)
#define DMA0_TCD22_WORD5                 (DMA0_BASE + DMA_TCD22_WORD5_OFFSET)
#define DMA0_TCD22_WORD6                 (DMA0_BASE + DMA_TCD22_WORD6_OFFSET)
#define DMA0_TCD22_WORD7                 (DMA0_BASE + DMA_TCD22_WORD7_OFFSET)
#define DMA0_TCD23_WORD0                 (DMA0_BASE + DMA_TCD23_WORD0_OFFSET)
#define DMA0_TCD23_WORD1                 (DMA0_BASE + DMA_TCD23_WORD1_OFFSET)
#define DMA0_TCD23_WORD2                 (DMA0_BASE + DMA_TCD23_WORD2_OFFSET)
#define DMA0_TCD23_WORD3                 (DMA0_BASE + DMA_TCD23_WORD3_OFFSET)
#define DMA0_TCD23_WORD4                 (DMA0_BASE + DMA_TCD23_WORD4_OFFSET)
#define DMA0_TCD23_WORD5                 (DMA0_BASE + DMA_TCD23_WORD5_OFFSET)
#define DMA0_TCD23_WORD6                 (DMA0_BASE + DMA_TCD23_WORD6_OFFSET)
#define DMA0_TCD23_WORD7                 (DMA0_BASE + DMA_TCD23_WORD7_OFFSET)
#define DMA0_TCD24_WORD0                 (DMA0_BASE + DMA_TCD24_WORD0_OFFSET)
#define DMA0_TCD24_WORD1                 (DMA0_BASE + DMA_TCD24_WORD1_OFFSET)
#define DMA0_TCD24_WORD2                 (DMA0_BASE + DMA_TCD24_WORD2_OFFSET)
#define DMA0_TCD24_WORD3                 (DMA0_BASE + DMA_TCD24_WORD3_OFFSET)
#define DMA0_TCD24_WORD4                 (DMA0_BASE + DMA_TCD24_WORD4_OFFSET)
#define DMA0_TCD24_WORD5                 (DMA0_BASE + DMA_TCD24_WORD5_OFFSET)
#define DMA0_TCD24_WORD6                 (DMA0_BASE + DMA_TCD24_WORD6_OFFSET)
#define DMA0_TCD24_WORD7                 (DMA0_BASE + DMA_TCD24_WORD7_OFFSET)
#define DMA0_TCD25_WORD0                 (DMA0_BASE + DMA_TCD25_WORD0_OFFSET)
#define DMA0_TCD25_WORD1                 (DMA0_BASE + DMA_TCD25_WORD1_OFFSET)
#define DMA0_TCD25_WORD2                 (DMA0_BASE + DMA_TCD25_WORD2_OFFSET)
#define DMA0_TCD25_WORD3                 (DMA0_BASE + DMA_TCD25_WORD3_OFFSET)
#define DMA0_TCD25_WORD4                 (DMA0_BASE + DMA_TCD25_WORD4_OFFSET)
#define DMA0_TCD25_WORD5                 (DMA0_BASE + DMA_TCD25_WORD5_OFFSET)
#define DMA0_TCD25_WORD6                 (DMA0_BASE + DMA_TCD25_WORD6_OFFSET)
#define DMA0_TCD25_WORD7                 (DMA0_BASE + DMA_TCD25_WORD7_OFFSET)
#define DMA0_TCD26_WORD0                 (DMA0_BASE + DMA_TCD26_WORD0_OFFSET)
#define DMA0_TCD26_WORD1                 (DMA0_BASE + DMA_TCD26_WORD1_OFFSET)
#define DMA0_TCD26_WORD2                 (DMA0_BASE + DMA_TCD26_WORD2_OFFSET)
#define DMA0_TCD26_WORD3                 (DMA0_BASE + DMA_TCD26_WORD3_OFFSET)
#define DMA0_TCD26_WORD4                 (DMA0_BASE + DMA_TCD26_WORD4_OFFSET)
#define DMA0_TCD26_WORD5                 (DMA0_BASE + DMA_TCD26_WORD5_OFFSET)
#define DMA0_TCD26_WORD6                 (DMA0_BASE + DMA_TCD26_WORD6_OFFSET)
#define DMA0_TCD26_WORD7                 (DMA0_BASE + DMA_TCD26_WORD7_OFFSET)
#define DMA0_TCD27_WORD0                 (DMA0_BASE + DMA_TCD27_WORD0_OFFSET)
#define DMA0_TCD27_WORD1                 (DMA0_BASE + DMA_TCD27_WORD1_OFFSET)
#define DMA0_TCD27_WORD2                 (DMA0_BASE + DMA_TCD27_WORD2_OFFSET)
#define DMA0_TCD27_WORD3                 (DMA0_BASE + DMA_TCD27_WORD3_OFFSET)
#define DMA0_TCD27_WORD4                 (DMA0_BASE + DMA_TCD27_WORD4_OFFSET)
#define DMA0_TCD27_WORD5                 (DMA0_BASE + DMA_TCD27_WORD5_OFFSET)
#define DMA0_TCD27_WORD6                 (DMA0_BASE + DMA_TCD27_WORD6_OFFSET)
#define DMA0_TCD27_WORD7                 (DMA0_BASE + DMA_TCD27_WORD7_OFFSET)
#define DMA0_TCD28_WORD0                 (DMA0_BASE + DMA_TCD28_WORD0_OFFSET)
#define DMA0_TCD28_WORD1                 (DMA0_BASE + DMA_TCD28_WORD1_OFFSET)
#define DMA0_TCD28_WORD2                 (DMA0_BASE + DMA_TCD28_WORD2_OFFSET)
#define DMA0_TCD28_WORD3                 (DMA0_BASE + DMA_TCD28_WORD3_OFFSET)
#define DMA0_TCD28_WORD4                 (DMA0_BASE + DMA_TCD28_WORD4_OFFSET)
#define DMA0_TCD28_WORD5                 (DMA0_BASE + DMA_TCD28_WORD5_OFFSET)
#define DMA0_TCD28_WORD6                 (DMA0_BASE + DMA_TCD28_WORD6_OFFSET)
#define DMA0_TCD28_WORD7                 (DMA0_BASE + DMA_TCD28_WORD7_OFFSET)
#define DMA0_TCD29_WORD0                 (DMA0_BASE + DMA_TCD29_WORD0_OFFSET)
#define DMA0_TCD29_WORD1                 (DMA0_BASE + DMA_TCD29_WORD1_OFFSET)
#define DMA0_TCD29_WORD2                 (DMA0_BASE + DMA_TCD29_WORD2_OFFSET)
#define DMA0_TCD29_WORD3                 (DMA0_BASE + DMA_TCD29_WORD3_OFFSET)
#define DMA0_TCD29_WORD4                 (DMA0_BASE + DMA_TCD29_WORD4_OFFSET)
#define DMA0_TCD29_WORD5                 (DMA0_BASE + DMA_TCD29_WORD5_OFFSET)
#define DMA0_TCD29_WORD6                 (DMA0_BASE + DMA_TCD29_WORD6_OFFSET)
#define DMA0_TCD29_WORD7                 (DMA0_BASE + DMA_TCD29_WORD7_OFFSET)
#define DMA0_TCD30_WORD0                 (DMA0_BASE + DMA_TCD30_WORD0_OFFSET)
#define DMA0_TCD30_WORD1                 (DMA0_BASE + DMA_TCD30_WORD1_OFFSET)
#define DMA0_TCD30_WORD2                 (DMA0_BASE + DMA_TCD30_WORD2_OFFSET)
#define DMA0_TCD30_WORD3                 (DMA0_BASE + DMA_TCD30_WORD3_OFFSET)
#define DMA0_TCD30_WORD4                 (DMA0_BASE + DMA_TCD30_WORD4_OFFSET)
#define DMA0_TCD30_WORD5                 (DMA0_BASE + DMA_TCD30_WORD5_OFFSET)
#define DMA0_TCD30_WORD6                 (DMA0_BASE + DMA_TCD30_WORD6_OFFSET)
#define DMA0_TCD30_WORD7                 (DMA0_BASE + DMA_TCD30_WORD7_OFFSET)
#define DMA0_TCD31_WORD0                 (DMA0_BASE + DMA_TCD31_WORD0_OFFSET)
#define DMA0_TCD31_WORD1                 (DMA0_BASE + DMA_TCD31_WORD1_OFFSET)
#define DMA0_TCD31_WORD2                 (DMA0_BASE + DMA_TCD31_WORD2_OFFSET)
#define DMA0_TCD31_WORD3                 (DMA0_BASE + DMA_TCD31_WORD3_OFFSET)
#define DMA0_TCD31_WORD4                 (DMA0_BASE + DMA_TCD31_WORD4_OFFSET)
#define DMA0_TCD31_WORD5                 (DMA0_BASE + DMA_TCD31_WORD5_OFFSET)
#define DMA0_TCD31_WORD6                 (DMA0_BASE + DMA_TCD31_WORD6_OFFSET)
#define DMA0_TCD31_WORD7                 (DMA0_BASE + DMA_TCD31_WORD7_OFFSET)

#define DMA1_CR                          (DMA1_BASE + DMA_CR_OFFSET)
#define DMA1_ES                          (DMA1_BASE + DMA_ES_OFFSET)
#define DMA1_ERQ                         (DMA1_BASE + DMA_ERQ_OFFSET)
#define DMA1_EEI                         (DMA1_BASE + DMA_EEI_OFFSET)
#define DMA1_CEEI                        (DMA1_BASE + DMA_CEEI_OFFSET)
#define DMA1_SEEI                        (DMA1_BASE + DMA_SEEI_OFFSET)
#define DMA1_CERQ                        (DMA1_BASE + DMA_CERQ_OFFSET)
#define DMA1_SERQ                        (DMA1_BASE + DMA_SERQ_OFFSET)
#define DMA1_CDNE                        (DMA1_BASE + DMA_CDNE_OFFSET)
#define DMA1_SSRT                        (DMA1_BASE + DMA_SSRT_OFFSET)
#define DMA1_CERR                        (DMA1_BASE + DMA_CERR_OFFSET)
#define DMA1_CINT                        (DMA1_BASE + DMA_CINT_OFFSET)
#define DMA1_INT                         (DMA1_BASE + DMA_INT_OFFSET)
#define DMA1_ERR                         (DMA1_BASE + DMA_ERR_OFFSET)
#define DMA1_HRS                         (DMA1_BASE + DMA_HRS_OFFSET)
#define DMA1_DCHPRI3                     (DMA1_BASE + DMA_DCHPRI3_OFFSET)
#define DMA1_DCHPRI2                     (DMA1_BASE + DMA_DCHPRI2_OFFSET)
#define DMA1_DCHPRI1                     (DMA1_BASE + DMA_DCHPRI1_OFFSET)
#define DMA1_DCHPRI0                     (DMA1_BASE + DMA_DCHPRI0_OFFSET)
#define DMA1_DCHPRI7                     (DMA1_BASE + DMA_DCHPRI7_OFFSET)
#define DMA1_DCHPRI6                     (DMA1_BASE + DMA_DCHPRI6_OFFSET)
#define DMA1_DCHPRI5                     (DMA1_BASE + DMA_DCHPRI5_OFFSET)
#define DMA1_DCHPRI4                     (DMA1_BASE + DMA_DCHPRI4_OFFSET)
#define DMA1_DCHPRI11                    (DMA1_BASE + DMA_DCHPRI11_OFFSET)
#define DMA1_DCHPRI10                    (DMA1_BASE + DMA_DCHPRI10_OFFSET)
#define DMA1_DCHPRI9                     (DMA1_BASE + DMA_DCHPRI9_OFFSET)
#define DMA1_DCHPRI8                     (DMA1_BASE + DMA_DCHPRI8_OFFSET)
#define DMA1_DCHPRI15                    (DMA1_BASE + DMA_DCHPRI15_OFFSET)
#define DMA1_DCHPRI14                    (DMA1_BASE + DMA_DCHPRI14_OFFSET)
#define DMA1_DCHPRI13                    (DMA1_BASE + DMA_DCHPRI13_OFFSET)
#define DMA1_DCHPRI12                    (DMA1_BASE + DMA_DCHPRI12_OFFSET)
#define DMA1_DCHPRI19                    (DMA1_BASE + DMA_DCHPRI19_OFFSET)
#define DMA1_DCHPRI18                    (DMA1_BASE + DMA_DCHPRI18_OFFSET)
#define DMA1_DCHPRI17                    (DMA1_BASE + DMA_DCHPRI17_OFFSET)
#define DMA1_DCHPRI16                    (DMA1_BASE + DMA_DCHPRI16_OFFSET)
#define DMA1_DCHPRI23                    (DMA1_BASE + DMA_DCHPRI23_OFFSET)
#define DMA1_DCHPRI22                    (DMA1_BASE + DMA_DCHPRI22_OFFSET)
#define DMA1_DCHPRI21                    (DMA1_BASE + DMA_DCHPRI21_OFFSET)
#define DMA1_DCHPRI20                    (DMA1_BASE + DMA_DCHPRI20_OFFSET)
#define DMA1_DCHPRI27                    (DMA1_BASE + DMA_DCHPRI27_OFFSET)
#define DMA1_DCHPRI26                    (DMA1_BASE + DMA_DCHPRI26_OFFSET)
#define DMA1_DCHPRI25                    (DMA1_BASE + DMA_DCHPRI25_OFFSET)
#define DMA1_DCHPRI24                    (DMA1_BASE + DMA_DCHPRI24_OFFSET)
#define DMA1_DCHPRI31                    (DMA1_BASE + DMA_DCHPRI31_OFFSET)
#define DMA1_DCHPRI30                    (DMA1_BASE + DMA_DCHPRI30_OFFSET)
#define DMA1_DCHPRI29                    (DMA1_BASE + DMA_DCHPRI29_OFFSET)
#define DMA1_DCHPRI28                    (DMA1_BASE + DMA_DCHPRI28_OFFSET)
#define DMA1_TCD0_WORD0                  (DMA1_BASE + DMA_TCD0_WORD0_OFFSET)
#define DMA1_TCD0_WORD1                  (DMA1_BASE + DMA_TCD0_WORD1_OFFSET)
#define DMA1_TCD0_WORD2                  (DMA1_BASE + DMA_TCD0_WORD2_OFFSET)
#define DMA1_TCD0_WORD3                  (DMA1_BASE + DMA_TCD0_WORD3_OFFSET)
#define DMA1_TCD0_WORD4                  (DMA1_BASE + DMA_TCD0_WORD4_OFFSET)
#define DMA1_TCD0_WORD5                  (DMA1_BASE + DMA_TCD0_WORD5_OFFSET)
#define DMA1_TCD0_WORD6                  (DMA1_BASE + DMA_TCD0_WORD6_OFFSET)
#define DMA1_TCD0_WORD7                  (DMA1_BASE + DMA_TCD0_WORD7_OFFSET)
#define DMA1_TCD1_WORD0                  (DMA1_BASE + DMA_TCD1_WORD0_OFFSET)
#define DMA1_TCD1_WORD1                  (DMA1_BASE + DMA_TCD1_WORD1_OFFSET)
#define DMA1_TCD1_WORD2                  (DMA1_BASE + DMA_TCD1_WORD2_OFFSET)
#define DMA1_TCD1_WORD3                  (DMA1_BASE + DMA_TCD1_WORD3_OFFSET)
#define DMA1_TCD1_WORD4                  (DMA1_BASE + DMA_TCD1_WORD4_OFFSET)
#define DMA1_TCD1_WORD5                  (DMA1_BASE + DMA_TCD1_WORD5_OFFSET)
#define DMA1_TCD1_WORD6                  (DMA1_BASE + DMA_TCD1_WORD6_OFFSET)
#define DMA1_TCD1_WORD7                  (DMA1_BASE + DMA_TCD1_WORD7_OFFSET)
#define DMA1_TCD2_WORD0                  (DMA1_BASE + DMA_TCD2_WORD0_OFFSET)
#define DMA1_TCD2_WORD1                  (DMA1_BASE + DMA_TCD2_WORD1_OFFSET)
#define DMA1_TCD2_WORD2                  (DMA1_BASE + DMA_TCD2_WORD2_OFFSET)
#define DMA1_TCD2_WORD3                  (DMA1_BASE + DMA_TCD2_WORD3_OFFSET)
#define DMA1_TCD2_WORD4                  (DMA1_BASE + DMA_TCD2_WORD4_OFFSET)
#define DMA1_TCD2_WORD5                  (DMA1_BASE + DMA_TCD2_WORD5_OFFSET)
#define DMA1_TCD2_WORD6                  (DMA1_BASE + DMA_TCD2_WORD6_OFFSET)
#define DMA1_TCD2_WORD7                  (DMA1_BASE + DMA_TCD2_WORD7_OFFSET)
#define DMA1_TCD3_WORD0                  (DMA1_BASE + DMA_TCD3_WORD0_OFFSET)
#define DMA1_TCD3_WORD1                  (DMA1_BASE + DMA_TCD3_WORD1_OFFSET)
#define DMA1_TCD3_WORD2                  (DMA1_BASE + DMA_TCD3_WORD2_OFFSET)
#define DMA1_TCD3_WORD3                  (DMA1_BASE + DMA_TCD3_WORD3_OFFSET)
#define DMA1_TCD3_WORD4                  (DMA1_BASE + DMA_TCD3_WORD4_OFFSET)
#define DMA1_TCD3_WORD5                  (DMA1_BASE + DMA_TCD3_WORD5_OFFSET)
#define DMA1_TCD3_WORD6                  (DMA1_BASE + DMA_TCD3_WORD6_OFFSET)
#define DMA1_TCD3_WORD7                  (DMA1_BASE + DMA_TCD3_WORD7_OFFSET)
#define DMA1_TCD4_WORD0                  (DMA1_BASE + DMA_TCD4_WORD0_OFFSET)
#define DMA1_TCD4_WORD1                  (DMA1_BASE + DMA_TCD4_WORD1_OFFSET)
#define DMA1_TCD4_WORD2                  (DMA1_BASE + DMA_TCD4_WORD2_OFFSET)
#define DMA1_TCD4_WORD3                  (DMA1_BASE + DMA_TCD4_WORD3_OFFSET)
#define DMA1_TCD4_WORD4                  (DMA1_BASE + DMA_TCD4_WORD4_OFFSET)
#define DMA1_TCD4_WORD5                  (DMA1_BASE + DMA_TCD4_WORD5_OFFSET)
#define DMA1_TCD4_WORD6                  (DMA1_BASE + DMA_TCD4_WORD6_OFFSET)
#define DMA1_TCD4_WORD7                  (DMA1_BASE + DMA_TCD4_WORD7_OFFSET)
#define DMA1_TCD5_WORD0                  (DMA1_BASE + DMA_TCD5_WORD0_OFFSET)
#define DMA1_TCD5_WORD1                  (DMA1_BASE + DMA_TCD5_WORD1_OFFSET)
#define DMA1_TCD5_WORD2                  (DMA1_BASE + DMA_TCD5_WORD2_OFFSET)
#define DMA1_TCD5_WORD3                  (DMA1_BASE + DMA_TCD5_WORD3_OFFSET)
#define DMA1_TCD5_WORD4                  (DMA1_BASE + DMA_TCD5_WORD4_OFFSET)
#define DMA1_TCD5_WORD5                  (DMA1_BASE + DMA_TCD5_WORD5_OFFSET)
#define DMA1_TCD5_WORD6                  (DMA1_BASE + DMA_TCD5_WORD6_OFFSET)
#define DMA1_TCD5_WORD7                  (DMA1_BASE + DMA_TCD5_WORD7_OFFSET)
#define DMA1_TCD6_WORD0                  (DMA1_BASE + DMA_TCD6_WORD0_OFFSET)
#define DMA1_TCD6_WORD1                  (DMA1_BASE + DMA_TCD6_WORD1_OFFSET)
#define DMA1_TCD6_WORD2                  (DMA1_BASE + DMA_TCD6_WORD2_OFFSET)
#define DMA1_TCD6_WORD3                  (DMA1_BASE + DMA_TCD6_WORD3_OFFSET)
#define DMA1_TCD6_WORD4                  (DMA1_BASE + DMA_TCD6_WORD4_OFFSET)
#define DMA1_TCD6_WORD5                  (DMA1_BASE + DMA_TCD6_WORD5_OFFSET)
#define DMA1_TCD6_WORD6                  (DMA1_BASE + DMA_TCD6_WORD6_OFFSET)
#define DMA1_TCD6_WORD7                  (DMA1_BASE + DMA_TCD6_WORD7_OFFSET)
#define DMA1_TCD7_WORD0                  (DMA1_BASE + DMA_TCD7_WORD0_OFFSET)
#define DMA1_TCD7_WORD1                  (DMA1_BASE + DMA_TCD7_WORD1_OFFSET)
#define DMA1_TCD7_WORD2                  (DMA1_BASE + DMA_TCD7_WORD2_OFFSET)
#define DMA1_TCD7_WORD3                  (DMA1_BASE + DMA_TCD7_WORD3_OFFSET)
#define DMA1_TCD7_WORD4                  (DMA1_BASE + DMA_TCD7_WORD4_OFFSET)
#define DMA1_TCD7_WORD5                  (DMA1_BASE + DMA_TCD7_WORD5_OFFSET)
#define DMA1_TCD7_WORD6                  (DMA1_BASE + DMA_TCD7_WORD6_OFFSET)
#define DMA1_TCD7_WORD7                  (DMA1_BASE + DMA_TCD7_WORD7_OFFSET)
#define DMA1_TCD8_WORD0                  (DMA1_BASE + DMA_TCD8_WORD0_OFFSET)
#define DMA1_TCD8_WORD1                  (DMA1_BASE + DMA_TCD8_WORD1_OFFSET)
#define DMA1_TCD8_WORD2                  (DMA1_BASE + DMA_TCD8_WORD2_OFFSET)
#define DMA1_TCD8_WORD3                  (DMA1_BASE + DMA_TCD8_WORD3_OFFSET)
#define DMA1_TCD8_WORD4                  (DMA1_BASE + DMA_TCD8_WORD4_OFFSET)
#define DMA1_TCD8_WORD5                  (DMA1_BASE + DMA_TCD8_WORD5_OFFSET)
#define DMA1_TCD8_WORD6                  (DMA1_BASE + DMA_TCD8_WORD6_OFFSET)
#define DMA1_TCD8_WORD7                  (DMA1_BASE + DMA_TCD8_WORD7_OFFSET)
#define DMA1_TCD9_WORD0                  (DMA1_BASE + DMA_TCD9_WORD0_OFFSET)
#define DMA1_TCD9_WORD1                  (DMA1_BASE + DMA_TCD9_WORD1_OFFSET)
#define DMA1_TCD9_WORD2                  (DMA1_BASE + DMA_TCD9_WORD2_OFFSET)
#define DMA1_TCD9_WORD3                  (DMA1_BASE + DMA_TCD9_WORD3_OFFSET)
#define DMA1_TCD9_WORD4                  (DMA1_BASE + DMA_TCD9_WORD4_OFFSET)
#define DMA1_TCD9_WORD5                  (DMA1_BASE + DMA_TCD9_WORD5_OFFSET)
#define DMA1_TCD9_WORD6                  (DMA1_BASE + DMA_TCD9_WORD6_OFFSET)
#define DMA1_TCD9_WORD7                  (DMA1_BASE + DMA_TCD9_WORD7_OFFSET)
#define DMA1_TCD10_WORD0                 (DMA1_BASE + DMA_TCD10_WORD0_OFFSET)
#define DMA1_TCD10_WORD1                 (DMA1_BASE + DMA_TCD10_WORD1_OFFSET)
#define DMA1_TCD10_WORD2                 (DMA1_BASE + DMA_TCD10_WORD2_OFFSET)
#define DMA1_TCD10_WORD3                 (DMA1_BASE + DMA_TCD10_WORD3_OFFSET)
#define DMA1_TCD10_WORD4                 (DMA1_BASE + DMA_TCD10_WORD4_OFFSET)
#define DMA1_TCD10_WORD5                 (DMA1_BASE + DMA_TCD10_WORD5_OFFSET)
#define DMA1_TCD10_WORD6                 (DMA1_BASE + DMA_TCD10_WORD6_OFFSET)
#define DMA1_TCD10_WORD7                 (DMA1_BASE + DMA_TCD10_WORD7_OFFSET)
#define DMA1_TCD11_WORD0                 (DMA1_BASE + DMA_TCD11_WORD0_OFFSET)
#define DMA1_TCD11_WORD1                 (DMA1_BASE + DMA_TCD11_WORD1_OFFSET)
#define DMA1_TCD11_WORD2                 (DMA1_BASE + DMA_TCD11_WORD2_OFFSET)
#define DMA1_TCD11_WORD3                 (DMA1_BASE + DMA_TCD11_WORD3_OFFSET)
#define DMA1_TCD11_WORD4                 (DMA1_BASE + DMA_TCD11_WORD4_OFFSET)
#define DMA1_TCD11_WORD5                 (DMA1_BASE + DMA_TCD11_WORD5_OFFSET)
#define DMA1_TCD11_WORD6                 (DMA1_BASE + DMA_TCD11_WORD6_OFFSET)
#define DMA1_TCD11_WORD7                 (DMA1_BASE + DMA_TCD11_WORD7_OFFSET)
#define DMA1_TCD12_WORD0                 (DMA1_BASE + DMA_TCD12_WORD0_OFFSET)
#define DMA1_TCD12_WORD1                 (DMA1_BASE + DMA_TCD12_WORD1_OFFSET)
#define DMA1_TCD12_WORD2                 (DMA1_BASE + DMA_TCD12_WORD2_OFFSET)
#define DMA1_TCD12_WORD3                 (DMA1_BASE + DMA_TCD12_WORD3_OFFSET)
#define DMA1_TCD12_WORD4                 (DMA1_BASE + DMA_TCD12_WORD4_OFFSET)
#define DMA1_TCD12_WORD5                 (DMA1_BASE + DMA_TCD12_WORD5_OFFSET)
#define DMA1_TCD12_WORD6                 (DMA1_BASE + DMA_TCD12_WORD6_OFFSET)
#define DMA1_TCD12_WORD7                 (DMA1_BASE + DMA_TCD12_WORD7_OFFSET)
#define DMA1_TCD13_WORD0                 (DMA1_BASE + DMA_TCD13_WORD0_OFFSET)
#define DMA1_TCD13_WORD1                 (DMA1_BASE + DMA_TCD13_WORD1_OFFSET)
#define DMA1_TCD13_WORD2                 (DMA1_BASE + DMA_TCD13_WORD2_OFFSET)
#define DMA1_TCD13_WORD3                 (DMA1_BASE + DMA_TCD13_WORD3_OFFSET)
#define DMA1_TCD13_WORD4                 (DMA1_BASE + DMA_TCD13_WORD4_OFFSET)
#define DMA1_TCD13_WORD5                 (DMA1_BASE + DMA_TCD13_WORD5_OFFSET)
#define DMA1_TCD13_WORD6                 (DMA1_BASE + DMA_TCD13_WORD6_OFFSET)
#define DMA1_TCD13_WORD7                 (DMA1_BASE + DMA_TCD13_WORD7_OFFSET)
#define DMA1_TCD14_WORD0                 (DMA1_BASE + DMA_TCD14_WORD0_OFFSET)
#define DMA1_TCD14_WORD1                 (DMA1_BASE + DMA_TCD14_WORD1_OFFSET)
#define DMA1_TCD14_WORD2                 (DMA1_BASE + DMA_TCD14_WORD2_OFFSET)
#define DMA1_TCD14_WORD3                 (DMA1_BASE + DMA_TCD14_WORD3_OFFSET)
#define DMA1_TCD14_WORD4                 (DMA1_BASE + DMA_TCD14_WORD4_OFFSET)
#define DMA1_TCD14_WORD5                 (DMA1_BASE + DMA_TCD14_WORD5_OFFSET)
#define DMA1_TCD14_WORD6                 (DMA1_BASE + DMA_TCD14_WORD6_OFFSET)
#define DMA1_TCD14_WORD7                 (DMA1_BASE + DMA_TCD14_WORD7_OFFSET)
#define DMA1_TCD15_WORD0                 (DMA1_BASE + DMA_TCD15_WORD0_OFFSET)
#define DMA1_TCD15_WORD1                 (DMA1_BASE + DMA_TCD15_WORD1_OFFSET)
#define DMA1_TCD15_WORD2                 (DMA1_BASE + DMA_TCD15_WORD2_OFFSET)
#define DMA1_TCD15_WORD3                 (DMA1_BASE + DMA_TCD15_WORD3_OFFSET)
#define DMA1_TCD15_WORD4                 (DMA1_BASE + DMA_TCD15_WORD4_OFFSET)
#define DMA1_TCD15_WORD5                 (DMA1_BASE + DMA_TCD15_WORD5_OFFSET)
#define DMA1_TCD15_WORD6                 (DMA1_BASE + DMA_TCD15_WORD6_OFFSET)
#define DMA1_TCD15_WORD7                 (DMA1_BASE + DMA_TCD15_WORD7_OFFSET)
#define DMA1_TCD16_WORD0                 (DMA1_BASE + DMA_TCD16_WORD0_OFFSET)
#define DMA1_TCD16_WORD1                 (DMA1_BASE + DMA_TCD16_WORD1_OFFSET)
#define DMA1_TCD16_WORD2                 (DMA1_BASE + DMA_TCD16_WORD2_OFFSET)
#define DMA1_TCD16_WORD3                 (DMA1_BASE + DMA_TCD16_WORD3_OFFSET)
#define DMA1_TCD16_WORD4                 (DMA1_BASE + DMA_TCD16_WORD4_OFFSET)
#define DMA1_TCD16_WORD5                 (DMA1_BASE + DMA_TCD16_WORD5_OFFSET)
#define DMA1_TCD16_WORD6                 (DMA1_BASE + DMA_TCD16_WORD6_OFFSET)
#define DMA1_TCD16_WORD7                 (DMA1_BASE + DMA_TCD16_WORD7_OFFSET)
#define DMA1_TCD17_WORD0                 (DMA1_BASE + DMA_TCD17_WORD0_OFFSET)
#define DMA1_TCD17_WORD1                 (DMA1_BASE + DMA_TCD17_WORD1_OFFSET)
#define DMA1_TCD17_WORD2                 (DMA1_BASE + DMA_TCD17_WORD2_OFFSET)
#define DMA1_TCD17_WORD3                 (DMA1_BASE + DMA_TCD17_WORD3_OFFSET)
#define DMA1_TCD17_WORD4                 (DMA1_BASE + DMA_TCD17_WORD4_OFFSET)
#define DMA1_TCD17_WORD5                 (DMA1_BASE + DMA_TCD17_WORD5_OFFSET)
#define DMA1_TCD17_WORD6                 (DMA1_BASE + DMA_TCD17_WORD6_OFFSET)
#define DMA1_TCD17_WORD7                 (DMA1_BASE + DMA_TCD17_WORD7_OFFSET)
#define DMA1_TCD18_WORD0                 (DMA1_BASE + DMA_TCD18_WORD0_OFFSET)
#define DMA1_TCD18_WORD1                 (DMA1_BASE + DMA_TCD18_WORD1_OFFSET)
#define DMA1_TCD18_WORD2                 (DMA1_BASE + DMA_TCD18_WORD2_OFFSET)
#define DMA1_TCD18_WORD3                 (DMA1_BASE + DMA_TCD18_WORD3_OFFSET)
#define DMA1_TCD18_WORD4                 (DMA1_BASE + DMA_TCD18_WORD4_OFFSET)
#define DMA1_TCD18_WORD5                 (DMA1_BASE + DMA_TCD18_WORD5_OFFSET)
#define DMA1_TCD18_WORD6                 (DMA1_BASE + DMA_TCD18_WORD6_OFFSET)
#define DMA1_TCD18_WORD7                 (DMA1_BASE + DMA_TCD18_WORD7_OFFSET)
#define DMA1_TCD19_WORD0                 (DMA1_BASE + DMA_TCD19_WORD0_OFFSET)
#define DMA1_TCD19_WORD1                 (DMA1_BASE + DMA_TCD19_WORD1_OFFSET)
#define DMA1_TCD19_WORD2                 (DMA1_BASE + DMA_TCD19_WORD2_OFFSET)
#define DMA1_TCD19_WORD3                 (DMA1_BASE + DMA_TCD19_WORD3_OFFSET)
#define DMA1_TCD19_WORD4                 (DMA1_BASE + DMA_TCD19_WORD4_OFFSET)
#define DMA1_TCD19_WORD5                 (DMA1_BASE + DMA_TCD19_WORD5_OFFSET)
#define DMA1_TCD19_WORD6                 (DMA1_BASE + DMA_TCD19_WORD6_OFFSET)
#define DMA1_TCD19_WORD7                 (DMA1_BASE + DMA_TCD19_WORD7_OFFSET)
#define DMA1_TCD20_WORD0                 (DMA1_BASE + DMA_TCD20_WORD0_OFFSET)
#define DMA1_TCD20_WORD1                 (DMA1_BASE + DMA_TCD20_WORD1_OFFSET)
#define DMA1_TCD20_WORD2                 (DMA1_BASE + DMA_TCD20_WORD2_OFFSET)
#define DMA1_TCD20_WORD3                 (DMA1_BASE + DMA_TCD20_WORD3_OFFSET)
#define DMA1_TCD20_WORD4                 (DMA1_BASE + DMA_TCD20_WORD4_OFFSET)
#define DMA1_TCD20_WORD5                 (DMA1_BASE + DMA_TCD20_WORD5_OFFSET)
#define DMA1_TCD20_WORD6                 (DMA1_BASE + DMA_TCD20_WORD6_OFFSET)
#define DMA1_TCD20_WORD7                 (DMA1_BASE + DMA_TCD20_WORD7_OFFSET)
#define DMA1_TCD21_WORD0                 (DMA1_BASE + DMA_TCD21_WORD0_OFFSET)
#define DMA1_TCD21_WORD1                 (DMA1_BASE + DMA_TCD21_WORD1_OFFSET)
#define DMA1_TCD21_WORD2                 (DMA1_BASE + DMA_TCD21_WORD2_OFFSET)
#define DMA1_TCD21_WORD3                 (DMA1_BASE + DMA_TCD21_WORD3_OFFSET)
#define DMA1_TCD21_WORD4                 (DMA1_BASE + DMA_TCD21_WORD4_OFFSET)
#define DMA1_TCD21_WORD5                 (DMA1_BASE + DMA_TCD21_WORD5_OFFSET)
#define DMA1_TCD21_WORD6                 (DMA1_BASE + DMA_TCD21_WORD6_OFFSET)
#define DMA1_TCD21_WORD7                 (DMA1_BASE + DMA_TCD21_WORD7_OFFSET)
#define DMA1_TCD22_WORD0                 (DMA1_BASE + DMA_TCD22_WORD0_OFFSET)
#define DMA1_TCD22_WORD1                 (DMA1_BASE + DMA_TCD22_WORD1_OFFSET)
#define DMA1_TCD22_WORD2                 (DMA1_BASE + DMA_TCD22_WORD2_OFFSET)
#define DMA1_TCD22_WORD3                 (DMA1_BASE + DMA_TCD22_WORD3_OFFSET)
#define DMA1_TCD22_WORD4                 (DMA1_BASE + DMA_TCD22_WORD4_OFFSET)
#define DMA1_TCD22_WORD5                 (DMA1_BASE + DMA_TCD22_WORD5_OFFSET)
#define DMA1_TCD22_WORD6                 (DMA1_BASE + DMA_TCD22_WORD6_OFFSET)
#define DMA1_TCD22_WORD7                 (DMA1_BASE + DMA_TCD22_WORD7_OFFSET)
#define DMA1_TCD23_WORD0                 (DMA1_BASE + DMA_TCD23_WORD0_OFFSET)
#define DMA1_TCD23_WORD1                 (DMA1_BASE + DMA_TCD23_WORD1_OFFSET)
#define DMA1_TCD23_WORD2                 (DMA1_BASE + DMA_TCD23_WORD2_OFFSET)
#define DMA1_TCD23_WORD3                 (DMA1_BASE + DMA_TCD23_WORD3_OFFSET)
#define DMA1_TCD23_WORD4                 (DMA1_BASE + DMA_TCD23_WORD4_OFFSET)
#define DMA1_TCD23_WORD5                 (DMA1_BASE + DMA_TCD23_WORD5_OFFSET)
#define DMA1_TCD23_WORD6                 (DMA1_BASE + DMA_TCD23_WORD6_OFFSET)
#define DMA1_TCD23_WORD7                 (DMA1_BASE + DMA_TCD23_WORD7_OFFSET)
#define DMA1_TCD24_WORD0                 (DMA1_BASE + DMA_TCD24_WORD0_OFFSET)
#define DMA1_TCD24_WORD1                 (DMA1_BASE + DMA_TCD24_WORD1_OFFSET)
#define DMA1_TCD24_WORD2                 (DMA1_BASE + DMA_TCD24_WORD2_OFFSET)
#define DMA1_TCD24_WORD3                 (DMA1_BASE + DMA_TCD24_WORD3_OFFSET)
#define DMA1_TCD24_WORD4                 (DMA1_BASE + DMA_TCD24_WORD4_OFFSET)
#define DMA1_TCD24_WORD5                 (DMA1_BASE + DMA_TCD24_WORD5_OFFSET)
#define DMA1_TCD24_WORD6                 (DMA1_BASE + DMA_TCD24_WORD6_OFFSET)
#define DMA1_TCD24_WORD7                 (DMA1_BASE + DMA_TCD24_WORD7_OFFSET)
#define DMA1_TCD25_WORD0                 (DMA1_BASE + DMA_TCD25_WORD0_OFFSET)
#define DMA1_TCD25_WORD1                 (DMA1_BASE + DMA_TCD25_WORD1_OFFSET)
#define DMA1_TCD25_WORD2                 (DMA1_BASE + DMA_TCD25_WORD2_OFFSET)
#define DMA1_TCD25_WORD3                 (DMA1_BASE + DMA_TCD25_WORD3_OFFSET)
#define DMA1_TCD25_WORD4                 (DMA1_BASE + DMA_TCD25_WORD4_OFFSET)
#define DMA1_TCD25_WORD5                 (DMA1_BASE + DMA_TCD25_WORD5_OFFSET)
#define DMA1_TCD25_WORD6                 (DMA1_BASE + DMA_TCD25_WORD6_OFFSET)
#define DMA1_TCD25_WORD7                 (DMA1_BASE + DMA_TCD25_WORD7_OFFSET)
#define DMA1_TCD26_WORD0                 (DMA1_BASE + DMA_TCD26_WORD0_OFFSET)
#define DMA1_TCD26_WORD1                 (DMA1_BASE + DMA_TCD26_WORD1_OFFSET)
#define DMA1_TCD26_WORD2                 (DMA1_BASE + DMA_TCD26_WORD2_OFFSET)
#define DMA1_TCD26_WORD3                 (DMA1_BASE + DMA_TCD26_WORD3_OFFSET)
#define DMA1_TCD26_WORD4                 (DMA1_BASE + DMA_TCD26_WORD4_OFFSET)
#define DMA1_TCD26_WORD5                 (DMA1_BASE + DMA_TCD26_WORD5_OFFSET)
#define DMA1_TCD26_WORD6                 (DMA1_BASE + DMA_TCD26_WORD6_OFFSET)
#define DMA1_TCD26_WORD7                 (DMA1_BASE + DMA_TCD26_WORD7_OFFSET)
#define DMA1_TCD27_WORD0                 (DMA1_BASE + DMA_TCD27_WORD0_OFFSET)
#define DMA1_TCD27_WORD1                 (DMA1_BASE + DMA_TCD27_WORD1_OFFSET)
#define DMA1_TCD27_WORD2                 (DMA1_BASE + DMA_TCD27_WORD2_OFFSET)
#define DMA1_TCD27_WORD3                 (DMA1_BASE + DMA_TCD27_WORD3_OFFSET)
#define DMA1_TCD27_WORD4                 (DMA1_BASE + DMA_TCD27_WORD4_OFFSET)
#define DMA1_TCD27_WORD5                 (DMA1_BASE + DMA_TCD27_WORD5_OFFSET)
#define DMA1_TCD27_WORD6                 (DMA1_BASE + DMA_TCD27_WORD6_OFFSET)
#define DMA1_TCD27_WORD7                 (DMA1_BASE + DMA_TCD27_WORD7_OFFSET)
#define DMA1_TCD28_WORD0                 (DMA1_BASE + DMA_TCD28_WORD0_OFFSET)
#define DMA1_TCD28_WORD1                 (DMA1_BASE + DMA_TCD28_WORD1_OFFSET)
#define DMA1_TCD28_WORD2                 (DMA1_BASE + DMA_TCD28_WORD2_OFFSET)
#define DMA1_TCD28_WORD3                 (DMA1_BASE + DMA_TCD28_WORD3_OFFSET)
#define DMA1_TCD28_WORD4                 (DMA1_BASE + DMA_TCD28_WORD4_OFFSET)
#define DMA1_TCD28_WORD5                 (DMA1_BASE + DMA_TCD28_WORD5_OFFSET)
#define DMA1_TCD28_WORD6                 (DMA1_BASE + DMA_TCD28_WORD6_OFFSET)
#define DMA1_TCD28_WORD7                 (DMA1_BASE + DMA_TCD28_WORD7_OFFSET)
#define DMA1_TCD29_WORD0                 (DMA1_BASE + DMA_TCD29_WORD0_OFFSET)
#define DMA1_TCD29_WORD1                 (DMA1_BASE + DMA_TCD29_WORD1_OFFSET)
#define DMA1_TCD29_WORD2                 (DMA1_BASE + DMA_TCD29_WORD2_OFFSET)
#define DMA1_TCD29_WORD3                 (DMA1_BASE + DMA_TCD29_WORD3_OFFSET)
#define DMA1_TCD29_WORD4                 (DMA1_BASE + DMA_TCD29_WORD4_OFFSET)
#define DMA1_TCD29_WORD5                 (DMA1_BASE + DMA_TCD29_WORD5_OFFSET)
#define DMA1_TCD29_WORD6                 (DMA1_BASE + DMA_TCD29_WORD6_OFFSET)
#define DMA1_TCD29_WORD7                 (DMA1_BASE + DMA_TCD29_WORD7_OFFSET)
#define DMA1_TCD30_WORD0                 (DMA1_BASE + DMA_TCD30_WORD0_OFFSET)
#define DMA1_TCD30_WORD1                 (DMA1_BASE + DMA_TCD30_WORD1_OFFSET)
#define DMA1_TCD30_WORD2                 (DMA1_BASE + DMA_TCD30_WORD2_OFFSET)
#define DMA1_TCD30_WORD3                 (DMA1_BASE + DMA_TCD30_WORD3_OFFSET)
#define DMA1_TCD30_WORD4                 (DMA1_BASE + DMA_TCD30_WORD4_OFFSET)
#define DMA1_TCD30_WORD5                 (DMA1_BASE + DMA_TCD30_WORD5_OFFSET)
#define DMA1_TCD30_WORD6                 (DMA1_BASE + DMA_TCD30_WORD6_OFFSET)
#define DMA1_TCD30_WORD7                 (DMA1_BASE + DMA_TCD30_WORD7_OFFSET)
#define DMA1_TCD31_WORD0                 (DMA1_BASE + DMA_TCD31_WORD0_OFFSET)
#define DMA1_TCD31_WORD1                 (DMA1_BASE + DMA_TCD31_WORD1_OFFSET)
#define DMA1_TCD31_WORD2                 (DMA1_BASE + DMA_TCD31_WORD2_OFFSET)
#define DMA1_TCD31_WORD3                 (DMA1_BASE + DMA_TCD31_WORD3_OFFSET)
#define DMA1_TCD31_WORD4                 (DMA1_BASE + DMA_TCD31_WORD4_OFFSET)
#define DMA1_TCD31_WORD5                 (DMA1_BASE + DMA_TCD31_WORD5_OFFSET)
#define DMA1_TCD31_WORD6                 (DMA1_BASE + DMA_TCD31_WORD6_OFFSET)
#define DMA1_TCD31_WORD7                 (DMA1_BASE + DMA_TCD31_WORD7_OFFSET)

/* Field definitions for CR */
#define DMA_CR_CX_SHIFT              (17)  
#define DMA_CR_CX_MASK               ((1) << (DMA_CR_CX_SHIFT)) 

#define DMA_CR_ECX_SHIFT             (16)  
#define DMA_CR_ECX_MASK              ((1) << (DMA_CR_ECX_SHIFT)) 


#define DMA_CR_GRP1PRI_SHIFT         (10)
#define DMA_CR_GRP1PRI_MASK          ((0x00000003) << (DMA_CR_GRP1PRI_SHIFT)) 

#define DMA_CR_GRP0PRI_SHIFT         (8)
#define DMA_CR_GRP0PRI_MASK          ((0x00000003) << (DMA_CR_GRP0PRI_SHIFT)) 

#define DMA_CR_EMLM_SHIFT            (7)  
#define DMA_CR_EMLM_MASK             ((1) << (DMA_CR_EMLM_SHIFT)) 

#define DMA_CR_CLM_SHIFT             (6)  
#define DMA_CR_CLM_MASK              ((1) << (DMA_CR_CLM_SHIFT)) 

#define DMA_CR_HALT_SHIFT            (5)  
#define DMA_CR_HALT_MASK             ((1) << (DMA_CR_HALT_SHIFT)) 

#define DMA_CR_HOE_SHIFT             (4)  
#define DMA_CR_HOE_MASK              ((1) << (DMA_CR_HOE_SHIFT)) 

#define DMA_CR_ERGA_SHIFT            (3)  
#define DMA_CR_ERGA_MASK             ((1) << (DMA_CR_ERGA_SHIFT)) 

#define DMA_CR_ERCA_SHIFT            (2)  
#define DMA_CR_ERCA_MASK             ((1) << (DMA_CR_ERCA_SHIFT)) 

#define DMA_CR_EDBG_SHIFT            (1)  
#define DMA_CR_EDBG_MASK             ((1) << (DMA_CR_EDBG_SHIFT)) 



/* Field definitions for ES */
#define DMA_ES_VLD_SHIFT             (31)  
#define DMA_ES_VLD_MASK              ((1) << (DMA_ES_VLD_SHIFT)) 

#define DMA_ES_ECX_SHIFT             (16)  
#define DMA_ES_ECX_MASK              ((1) << (DMA_ES_ECX_SHIFT)) 

#define DMA_ES_GPE_SHIFT             (15)  
#define DMA_ES_GPE_MASK              ((1) << (DMA_ES_GPE_SHIFT)) 

#define DMA_ES_CPE_SHIFT             (14)  
#define DMA_ES_CPE_MASK              ((1) << (DMA_ES_CPE_SHIFT)) 

#define DMA_ES_ERRCHN_SHIFT          (8)
#define DMA_ES_ERRCHN_MASK           ((0x0000001F) << (DMA_ES_ERRCHN_SHIFT)) 

#define DMA_ES_SAE_SHIFT             (7)  
#define DMA_ES_SAE_MASK              ((1) << (DMA_ES_SAE_SHIFT)) 

#define DMA_ES_SOE_SHIFT             (6)  
#define DMA_ES_SOE_MASK              ((1) << (DMA_ES_SOE_SHIFT)) 

#define DMA_ES_DAE_SHIFT             (5)  
#define DMA_ES_DAE_MASK              ((1) << (DMA_ES_DAE_SHIFT)) 

#define DMA_ES_DOE_SHIFT             (4)  
#define DMA_ES_DOE_MASK              ((1) << (DMA_ES_DOE_SHIFT)) 

#define DMA_ES_NCE_SHIFT             (3)  
#define DMA_ES_NCE_MASK              ((1) << (DMA_ES_NCE_SHIFT)) 

#define DMA_ES_SGE_SHIFT             (2)  
#define DMA_ES_SGE_MASK              ((1) << (DMA_ES_SGE_SHIFT)) 

#define DMA_ES_SBE_SHIFT             (1)  
#define DMA_ES_SBE_MASK              ((1) << (DMA_ES_SBE_SHIFT)) 

#define DMA_ES_DBE_SHIFT             (0)  
#define DMA_ES_DBE_MASK              ((1) << (DMA_ES_DBE_SHIFT)) 



/* Field definitions for ERQ */
#define DMA_ERQ_ERQ31_SHIFT             (31)
#define DMA_ERQ_ERQ31_MASK              ((1) << (DMA_ERQ_ERQ31_SHIFT)) 

#define DMA_ERQ_ERQ30_SHIFT             (30)
#define DMA_ERQ_ERQ30_MASK              ((1) << (DMA_ERQ_ERQ30_SHIFT)) 

#define DMA_ERQ_ERQ29_SHIFT             (29)
#define DMA_ERQ_ERQ29_MASK              ((1) << (DMA_ERQ_ERQ29_SHIFT)) 

#define DMA_ERQ_ERQ28_SHIFT             (28)
#define DMA_ERQ_ERQ28_MASK              ((1) << (DMA_ERQ_ERQ28_SHIFT))

#define DMA_ERQ_ERQ27_SHIFT             (27)
#define DMA_ERQ_ERQ27_MASK              ((1) << (DMA_ERQ_ERQ27_SHIFT))

#define DMA_ERQ_ERQ26_SHIFT             (26)
#define DMA_ERQ_ERQ26_MASK              ((1) << (DMA_ERQ_ERQ26_SHIFT))

#define DMA_ERQ_ERQ25_SHIFT             (25)
#define DMA_ERQ_ERQ25_MASK              ((1) << (DMA_ERQ_ERQ25_SHIFT))

#define DMA_ERQ_ERQ24_SHIFT             (24)
#define DMA_ERQ_ERQ24_MASK              ((1) << (DMA_ERQ_ERQ24_SHIFT))

#define DMA_ERQ_ERQ23_SHIFT             (23)
#define DMA_ERQ_ERQ23_MASK              ((1) << (DMA_ERQ_ERQ23_SHIFT))

#define DMA_ERQ_ERQ22_SHIFT             (22)
#define DMA_ERQ_ERQ22_MASK              ((1) << (DMA_ERQ_ERQ22_SHIFT))

#define DMA_ERQ_ERQ21_SHIFT             (21)
#define DMA_ERQ_ERQ21_MASK              ((1) << (DMA_ERQ_ERQ21_SHIFT))

#define DMA_ERQ_ERQ20_SHIFT             (20)
#define DMA_ERQ_ERQ20_MASK              ((1) << (DMA_ERQ_ERQ20_SHIFT))

#define DMA_ERQ_ERQ19_SHIFT             (19)
#define DMA_ERQ_ERQ19_MASK              ((1) << (DMA_ERQ_ERQ19_SHIFT)) 

#define DMA_ERQ_ERQ18_SHIFT             (18)
#define DMA_ERQ_ERQ18_MASK              ((1) << (DMA_ERQ_ERQ18_SHIFT))

#define DMA_ERQ_ERQ17_SHIFT             (17)
#define DMA_ERQ_ERQ17_MASK              ((1) << (DMA_ERQ_ERQ17_SHIFT))

#define DMA_ERQ_ERQ16_SHIFT             (16)
#define DMA_ERQ_ERQ16_MASK              ((1) << (DMA_ERQ_ERQ16_SHIFT))

#define DMA_ERQ_ERQ15_SHIFT             (15)
#define DMA_ERQ_ERQ15_MASK              ((1) << (DMA_ERQ_ERQ15_SHIFT))

#define DMA_ERQ_ERQ14_SHIFT             (14)
#define DMA_ERQ_ERQ14_MASK              ((1) << (DMA_ERQ_ERQ14_SHIFT))

#define DMA_ERQ_ERQ13_SHIFT             (13)
#define DMA_ERQ_ERQ13_MASK              ((1) << (DMA_ERQ_ERQ13_SHIFT))

#define DMA_ERQ_ERQ12_SHIFT             (12)
#define DMA_ERQ_ERQ12_MASK              ((1) << (DMA_ERQ_ERQ12_SHIFT))

#define DMA_ERQ_ERQ11_SHIFT             (11)
#define DMA_ERQ_ERQ11_MASK              ((1) << (DMA_ERQ_ERQ11_SHIFT))

#define DMA_ERQ_ERQ10_SHIFT             (10)
#define DMA_ERQ_ERQ10_MASK              ((1) << (DMA_ERQ_ERQ10_SHIFT))

#define DMA_ERQ_ERQ9_SHIFT             (9)
#define DMA_ERQ_ERQ9_MASK              ((1) << (DMA_ERQ_ERQ9_SHIFT)) 

#define DMA_ERQ_ERQ8_SHIFT             (8)
#define DMA_ERQ_ERQ8_MASK              ((1) << (DMA_ERQ_ERQ8_SHIFT))

#define DMA_ERQ_ERQ7_SHIFT             (7)
#define DMA_ERQ_ERQ7_MASK              ((1) << (DMA_ERQ_ERQ7_SHIFT))

#define DMA_ERQ_ERQ6_SHIFT             (6)
#define DMA_ERQ_ERQ6_MASK              ((1) << (DMA_ERQ_ERQ6_SHIFT))

#define DMA_ERQ_ERQ5_SHIFT             (5)
#define DMA_ERQ_ERQ5_MASK              ((1) << (DMA_ERQ_ERQ5_SHIFT))

#define DMA_ERQ_ERQ4_SHIFT             (4)
#define DMA_ERQ_ERQ4_MASK              ((1) << (DMA_ERQ_ERQ4_SHIFT))

#define DMA_ERQ_ERQ3_SHIFT             (3)
#define DMA_ERQ_ERQ3_MASK              ((1) << (DMA_ERQ_ERQ3_SHIFT))

#define DMA_ERQ_ERQ2_SHIFT             (2)
#define DMA_ERQ_ERQ2_MASK              ((1) << (DMA_ERQ_ERQ2_SHIFT))

#define DMA_ERQ_ERQ1_SHIFT             (1)
#define DMA_ERQ_ERQ1_MASK              ((1) << (DMA_ERQ_ERQ1_SHIFT))

#define DMA_ERQ_ERQ0_SHIFT             (0)
#define DMA_ERQ_ERQ0_MASK              ((1) << (DMA_ERQ_ERQ0_SHIFT))



/* Field definitions for EEI */
#define DMA_EEI_EEI31_SHIFT             (31)
#define DMA_EEI_EEI31_MASK              ((1) << (DMA_EEI_EEI31_SHIFT)) 

#define DMA_EEI_EEI30_SHIFT             (30)
#define DMA_EEI_EEI30_MASK              ((1) << (DMA_EEI_EEI30_SHIFT)) 

#define DMA_EEI_EEI29_SHIFT             (29)
#define DMA_EEI_EEI29_MASK              ((1) << (DMA_EEI_EEI29_SHIFT)) 

#define DMA_EEI_EEI28_SHIFT             (28)
#define DMA_EEI_EEI28_MASK              ((1) << (DMA_EEI_EEI28_SHIFT))

#define DMA_EEI_EEI27_SHIFT             (27)
#define DMA_EEI_EEI27_MASK              ((1) << (DMA_EEI_EEI27_SHIFT))

#define DMA_EEI_EEI26_SHIFT             (26)
#define DMA_EEI_EEI26_MASK              ((1) << (DMA_EEI_EEI26_SHIFT))

#define DMA_EEI_EEI25_SHIFT             (25)
#define DMA_EEI_EEI25_MASK              ((1) << (DMA_EEI_EEI25_SHIFT))

#define DMA_EEI_EEI24_SHIFT             (24)
#define DMA_EEI_EEI24_MASK              ((1) << (DMA_EEI_EEI24_SHIFT))

#define DMA_EEI_EEI23_SHIFT             (23)
#define DMA_EEI_EEI23_MASK              ((1) << (DMA_EEI_EEI23_SHIFT))

#define DMA_EEI_EEI22_SHIFT             (22)
#define DMA_EEI_EEI22_MASK              ((1) << (DMA_EEI_EEI22_SHIFT))

#define DMA_EEI_EEI21_SHIFT             (21)
#define DMA_EEI_EEI21_MASK              ((1) << (DMA_EEI_EEI21_SHIFT))

#define DMA_EEI_EEI20_SHIFT             (20)
#define DMA_EEI_EEI20_MASK              ((1) << (DMA_EEI_EEI20_SHIFT))

#define DMA_EEI_EEI19_SHIFT             (19)
#define DMA_EEI_EEI19_MASK              ((1) << (DMA_EEI_EEI19_SHIFT)) 

#define DMA_EEI_EEI18_SHIFT             (18)
#define DMA_EEI_EEI18_MASK              ((1) << (DMA_EEI_EEI18_SHIFT))

#define DMA_EEI_EEI17_SHIFT             (17)
#define DMA_EEI_EEI17_MASK              ((1) << (DMA_EEI_EEI17_SHIFT))

#define DMA_EEI_EEI16_SHIFT             (16)
#define DMA_EEI_EEI16_MASK              ((1) << (DMA_EEI_EEI16_SHIFT))

#define DMA_EEI_EEI15_SHIFT             (15)
#define DMA_EEI_EEI15_MASK              ((1) << (DMA_EEI_EEI15_SHIFT))

#define DMA_EEI_EEI14_SHIFT             (14)
#define DMA_EEI_EEI14_MASK              ((1) << (DMA_EEI_EEI14_SHIFT))

#define DMA_EEI_EEI13_SHIFT             (13)
#define DMA_EEI_EEI13_MASK              ((1) << (DMA_EEI_EEI13_SHIFT))

#define DMA_EEI_EEI12_SHIFT             (12)
#define DMA_EEI_EEI12_MASK              ((1) << (DMA_EEI_EEI12_SHIFT))

#define DMA_EEI_EEI11_SHIFT             (11)
#define DMA_EEI_EEI11_MASK              ((1) << (DMA_EEI_EEI11_SHIFT))

#define DMA_EEI_EEI10_SHIFT             (10)
#define DMA_EEI_EEI10_MASK              ((1) << (DMA_EEI_EEI10_SHIFT))

#define DMA_EEI_EEI9_SHIFT             (9)
#define DMA_EEI_EEI9_MASK              ((1) << (DMA_EEI_EEI9_SHIFT)) 

#define DMA_EEI_EEI8_SHIFT             (8)
#define DMA_EEI_EEI8_MASK              ((1) << (DMA_EEI_EEI8_SHIFT))

#define DMA_EEI_EEI7_SHIFT             (7)
#define DMA_EEI_EEI7_MASK              ((1) << (DMA_EEI_EEI7_SHIFT))

#define DMA_EEI_EEI6_SHIFT             (6)
#define DMA_EEI_EEI6_MASK              ((1) << (DMA_EEI_EEI6_SHIFT))

#define DMA_EEI_EEI5_SHIFT             (5)
#define DMA_EEI_EEI5_MASK              ((1) << (DMA_EEI_EEI5_SHIFT))

#define DMA_EEI_EEI4_SHIFT             (4)
#define DMA_EEI_EEI4_MASK              ((1) << (DMA_EEI_EEI4_SHIFT))

#define DMA_EEI_EEI3_SHIFT             (3)
#define DMA_EEI_EEI3_MASK              ((1) << (DMA_EEI_EEI3_SHIFT))

#define DMA_EEI_EEI2_SHIFT             (2)
#define DMA_EEI_EEI2_MASK              ((1) << (DMA_EEI_EEI2_SHIFT))

#define DMA_EEI_EEI1_SHIFT             (1)
#define DMA_EEI_EEI1_MASK              ((1) << (DMA_EEI_EEI1_SHIFT))

#define DMA_EEI_EEI0_SHIFT             (0)
#define DMA_EEI_EEI0_MASK              ((1) << (DMA_EEI_EEI0_SHIFT))



/* Field definitions for CEEI */
#define DMA_CEEI_NOP_SHIFT            (7)
#define DMA_CEEI_NOP_MASK             ((1) << (DMA_CEEI_NOP_SHIFT)) 

#define DMA_CEEI_CAEE_SHIFT            (6)
#define DMA_CEEI_CAEE_MASK             ((1) << (DMA_CEEI_CAEE_SHIFT)) 

#define DMA_CEEI_CEEI_SHIFT            (0)
#define DMA_CEEI_CEEI_MASK             ((0x1F) << (DMA_CEEI_CEEI_SHIFT)) 



/* Field definitions for SEEI */
#define DMA_SEEI_NOP_SHIFT            (7)
#define DMA_SEEI_NOP_MASK             ((1) << (DMA_SEEI_NOP_SHIFT)) 

#define DMA_SEEI_SAEE_SHIFT            (6)
#define DMA_SEEI_SAEE_MASK             ((1) << (DMA_SEEI_SAEE_SHIFT)) 

#define DMA_SEEI_SEEI_SHIFT            (0)
#define DMA_SEEI_SEEI_MASK             ((0x1F) << (DMA_SEEI_SEEI_SHIFT)) 



/* Field definitions for CERQ */
#define DMA_CERQ_NOP_SHIFT            (7)
#define DMA_CERQ_NOP_MASK             ((1) << (DMA_CERQ_NOP_SHIFT)) 

#define DMA_CERQ_CAER_SHIFT            (6)
#define DMA_CERQ_CAER_MASK             ((1) << (DMA_CERQ_CAER_SHIFT)) 

#define DMA_CERQ_CERQ_SHIFT            (0)
#define DMA_CERQ_CERQ_MASK             ((0x1F) << (DMA_CERQ_CERQ_SHIFT)) 



/* Field definitions for SERQ */
#define DMA_SERQ_NOP_SHIFT            (7)
#define DMA_SERQ_NOP_MASK             ((1) << (DMA_SERQ_NOP_SHIFT)) 

#define DMA_SERQ_SAER_SHIFT            (6)
#define DMA_SERQ_SAER_MASK             ((1) << (DMA_SERQ_SAER_SHIFT)) 

#define DMA_SERQ_SERQ_SHIFT            (0)
#define DMA_SERQ_SERQ_MASK             ((0x1F) << (DMA_SERQ_SERQ_SHIFT)) 




/* Field definitions for CDNE */
#define DMA_CDNE_NOP_SHIFT            (7)
#define DMA_CDNE_NOP_MASK             ((1) << (DMA_CDNE_NOP_SHIFT))

#define DMA_CDNE_CADN_SHIFT            (6)
#define DMA_CDNE_CADN_MASK             ((1) << (DMA_CDNE_CADN_SHIFT))

#define DMA_CDNE_CDNE_SHIFT            (0)
#define DMA_CDNE_CDNE_MASK             ((0x1F) << (DMA_CDNE_CDNE_SHIFT)) 



/* Field definitions for SSRT */
#define DMA_SSRT_NOP_SHIFT            (7)
#define DMA_SSRT_NOP_MASK             ((1) << (DMA_SSRT_NOP_SHIFT)) 

#define DMA_SSRT_SAST_SHIFT            (6)
#define DMA_SSRT_SAST_MASK             ((1) << (DMA_SSRT_SAST_SHIFT)) 

#define DMA_SSRT_SSRT_SHIFT            (0)
#define DMA_SSRT_SSRT_MASK             ((0x1F) << (DMA_SSRT_SSRT_SHIFT)) 



/* Field definitions for CERR */
#define DMA_CERR_NOP_SHIFT            (7)
#define DMA_CERR_NOP_MASK             ((1) << (DMA_CERR_NOP_SHIFT)) 

#define DMA_CERR_CAEI_SHIFT            (6)
#define DMA_CERR_CAEI_MASK             ((1) << (DMA_CERR_CAEI_SHIFT)) 

#define DMA_CERR_CERR_SHIFT            (0)
#define DMA_CERR_CERR_MASK             ((0x1F) << (DMA_CERR_CERR_SHIFT)) 



/* Field definitions for CINT */
#define DMA_CINT_NOP_SHIFT            (7)
#define DMA_CINT_NOP_MASK             ((1) << (DMA_CINT_NOP_SHIFT)) 

#define DMA_CINT_CAIR_SHIFT            (6)
#define DMA_CINT_CAIR_MASK             ((1) << (DMA_CINT_CAIR_SHIFT)) 

#define DMA_CINT_CINT_SHIFT            (0)
#define DMA_CINT_CINT_MASK             ((0x1F) << (DMA_CINT_CINT_SHIFT)) 




/* Field definitions for INT */
#define DMA_INT_INT31_SHIFT             (31)
#define DMA_INT_INT31_MASK              ((1) << (DMA_INT_INT31_SHIFT)) 

#define DMA_INT_INT30_SHIFT             (30)
#define DMA_INT_INT30_MASK              ((1) << (DMA_INT_INT30_SHIFT)) 

#define DMA_INT_INT29_SHIFT             (29)
#define DMA_INT_INT29_MASK              ((1) << (DMA_INT_INT29_SHIFT)) 

#define DMA_INT_INT28_SHIFT             (28)
#define DMA_INT_INT28_MASK              ((1) << (DMA_INT_INT28_SHIFT))

#define DMA_INT_INT27_SHIFT             (27)
#define DMA_INT_INT27_MASK              ((1) << (DMA_INT_INT27_SHIFT))

#define DMA_INT_INT26_SHIFT             (26)
#define DMA_INT_INT26_MASK              ((1) << (DMA_INT_INT26_SHIFT))

#define DMA_INT_INT25_SHIFT             (25)
#define DMA_INT_INT25_MASK              ((1) << (DMA_INT_INT25_SHIFT))

#define DMA_INT_INT24_SHIFT             (24)
#define DMA_INT_INT24_MASK              ((1) << (DMA_INT_INT24_SHIFT))

#define DMA_INT_INT23_SHIFT             (23)
#define DMA_INT_INT23_MASK              ((1) << (DMA_INT_INT23_SHIFT))

#define DMA_INT_INT22_SHIFT             (22)
#define DMA_INT_INT22_MASK              ((1) << (DMA_INT_INT22_SHIFT))

#define DMA_INT_INT21_SHIFT             (21)
#define DMA_INT_INT21_MASK              ((1) << (DMA_INT_INT21_SHIFT))

#define DMA_INT_INT20_SHIFT             (20)
#define DMA_INT_INT20_MASK              ((1) << (DMA_INT_INT20_SHIFT))

#define DMA_INT_INT19_SHIFT             (19)
#define DMA_INT_INT19_MASK              ((1) << (DMA_INT_INT19_SHIFT)) 

#define DMA_INT_INT18_SHIFT             (18)
#define DMA_INT_INT18_MASK              ((1) << (DMA_INT_INT18_SHIFT))

#define DMA_INT_INT17_SHIFT             (17)
#define DMA_INT_INT17_MASK              ((1) << (DMA_INT_INT17_SHIFT))

#define DMA_INT_INT16_SHIFT             (16)
#define DMA_INT_INT16_MASK              ((1) << (DMA_INT_INT16_SHIFT))

#define DMA_INT_INT15_SHIFT             (15)
#define DMA_INT_INT15_MASK              ((1) << (DMA_INT_INT15_SHIFT))

#define DMA_INT_INT14_SHIFT             (14)
#define DMA_INT_INT14_MASK              ((1) << (DMA_INT_INT14_SHIFT))

#define DMA_INT_INT13_SHIFT             (13)
#define DMA_INT_INT13_MASK              ((1) << (DMA_INT_INT13_SHIFT))

#define DMA_INT_INT12_SHIFT             (12)
#define DMA_INT_INT12_MASK              ((1) << (DMA_INT_INT12_SHIFT))

#define DMA_INT_INT11_SHIFT             (11)
#define DMA_INT_INT11_MASK              ((1) << (DMA_INT_INT11_SHIFT))

#define DMA_INT_INT10_SHIFT             (10)
#define DMA_INT_INT10_MASK              ((1) << (DMA_INT_INT10_SHIFT))

#define DMA_INT_INT9_SHIFT             (9)
#define DMA_INT_INT9_MASK              ((1) << (DMA_INT_INT9_SHIFT)) 

#define DMA_INT_INT8_SHIFT             (8)
#define DMA_INT_INT8_MASK              ((1) << (DMA_INT_INT8_SHIFT))

#define DMA_INT_INT7_SHIFT             (7)
#define DMA_INT_INT7_MASK              ((1) << (DMA_INT_INT7_SHIFT))

#define DMA_INT_INT6_SHIFT             (6)
#define DMA_INT_INT6_MASK              ((1) << (DMA_INT_INT6_SHIFT))

#define DMA_INT_INT5_SHIFT             (5)
#define DMA_INT_INT5_MASK              ((1) << (DMA_INT_INT5_SHIFT))

#define DMA_INT_INT4_SHIFT             (4)
#define DMA_INT_INT4_MASK              ((1) << (DMA_INT_INT4_SHIFT))

#define DMA_INT_INT3_SHIFT             (3)
#define DMA_INT_INT3_MASK              ((1) << (DMA_INT_INT3_SHIFT))

#define DMA_INT_INT2_SHIFT             (2)
#define DMA_INT_INT2_MASK              ((1) << (DMA_INT_INT2_SHIFT))

#define DMA_INT_INT1_SHIFT             (1)
#define DMA_INT_INT1_MASK              ((1) << (DMA_INT_INT1_SHIFT))

#define DMA_INT_INT0_SHIFT             (0)
#define DMA_INT_INT0_MASK              ((1) << (DMA_INT_INT0_SHIFT))




/* Field definitions for ERR */
#define DMA_ERR_ERR31_SHIFT             (31)
#define DMA_ERR_ERR31_MASK              ((1) << (DMA_ERR_ERR31_SHIFT)) 

#define DMA_ERR_ERR30_SHIFT             (30)
#define DMA_ERR_ERR30_MASK              ((1) << (DMA_ERR_ERR30_SHIFT)) 

#define DMA_ERR_ERR29_SHIFT             (29)
#define DMA_ERR_ERR29_MASK              ((1) << (DMA_ERR_ERR29_SHIFT)) 

#define DMA_ERR_ERR28_SHIFT             (28)
#define DMA_ERR_ERR28_MASK              ((1) << (DMA_ERR_ERR28_SHIFT))

#define DMA_ERR_ERR27_SHIFT             (27)
#define DMA_ERR_ERR27_MASK              ((1) << (DMA_ERR_ERR27_SHIFT))

#define DMA_ERR_ERR26_SHIFT             (26)
#define DMA_ERR_ERR26_MASK              ((1) << (DMA_ERR_ERR26_SHIFT))

#define DMA_ERR_ERR25_SHIFT             (25)
#define DMA_ERR_ERR25_MASK              ((1) << (DMA_ERR_ERR25_SHIFT))

#define DMA_ERR_ERR24_SHIFT             (24)
#define DMA_ERR_ERR24_MASK              ((1) << (DMA_ERR_ERR24_SHIFT))

#define DMA_ERR_ERR23_SHIFT             (23)
#define DMA_ERR_ERR23_MASK              ((1) << (DMA_ERR_ERR23_SHIFT))

#define DMA_ERR_ERR22_SHIFT             (22)
#define DMA_ERR_ERR22_MASK              ((1) << (DMA_ERR_ERR22_SHIFT))

#define DMA_ERR_ERR21_SHIFT             (21)
#define DMA_ERR_ERR21_MASK              ((1) << (DMA_ERR_ERR21_SHIFT))

#define DMA_ERR_ERR20_SHIFT             (20)
#define DMA_ERR_ERR20_MASK              ((1) << (DMA_ERR_ERR20_SHIFT))

#define DMA_ERR_ERR19_SHIFT             (19)
#define DMA_ERR_ERR19_MASK              ((1) << (DMA_ERR_ERR19_SHIFT)) 

#define DMA_ERR_ERR18_SHIFT             (18)
#define DMA_ERR_ERR18_MASK              ((1) << (DMA_ERR_ERR18_SHIFT))

#define DMA_ERR_ERR17_SHIFT             (17)
#define DMA_ERR_ERR17_MASK              ((1) << (DMA_ERR_ERR17_SHIFT))

#define DMA_ERR_ERR16_SHIFT             (16)
#define DMA_ERR_ERR16_MASK              ((1) << (DMA_ERR_ERR16_SHIFT))

#define DMA_ERR_ERR15_SHIFT             (15)
#define DMA_ERR_ERR15_MASK              ((1) << (DMA_ERR_ERR15_SHIFT))

#define DMA_ERR_ERR14_SHIFT             (14)
#define DMA_ERR_ERR14_MASK              ((1) << (DMA_ERR_ERR14_SHIFT))

#define DMA_ERR_ERR13_SHIFT             (13)
#define DMA_ERR_ERR13_MASK              ((1) << (DMA_ERR_ERR13_SHIFT))

#define DMA_ERR_ERR12_SHIFT             (12)
#define DMA_ERR_ERR12_MASK              ((1) << (DMA_ERR_ERR12_SHIFT))

#define DMA_ERR_ERR11_SHIFT             (11)
#define DMA_ERR_ERR11_MASK              ((1) << (DMA_ERR_ERR11_SHIFT))

#define DMA_ERR_ERR10_SHIFT             (10)
#define DMA_ERR_ERR10_MASK              ((1) << (DMA_ERR_ERR10_SHIFT))

#define DMA_ERR_ERR9_SHIFT             (9)
#define DMA_ERR_ERR9_MASK              ((1) << (DMA_ERR_ERR9_SHIFT)) 

#define DMA_ERR_ERR8_SHIFT             (8)
#define DMA_ERR_ERR8_MASK              ((1) << (DMA_ERR_ERR8_SHIFT))

#define DMA_ERR_ERR7_SHIFT             (7)
#define DMA_ERR_ERR7_MASK              ((1) << (DMA_ERR_ERR7_SHIFT))

#define DMA_ERR_ERR6_SHIFT             (6)
#define DMA_ERR_ERR6_MASK              ((1) << (DMA_ERR_ERR6_SHIFT))

#define DMA_ERR_ERR5_SHIFT             (5)
#define DMA_ERR_ERR5_MASK              ((1) << (DMA_ERR_ERR5_SHIFT))

#define DMA_ERR_ERR4_SHIFT             (4)
#define DMA_ERR_ERR4_MASK              ((1) << (DMA_ERR_ERR4_SHIFT))

#define DMA_ERR_ERR3_SHIFT             (3)
#define DMA_ERR_ERR3_MASK              ((1) << (DMA_ERR_ERR3_SHIFT))

#define DMA_ERR_ERR2_SHIFT             (2)
#define DMA_ERR_ERR2_MASK              ((1) << (DMA_ERR_ERR2_SHIFT))

#define DMA_ERR_ERR1_SHIFT             (1)
#define DMA_ERR_ERR1_MASK              ((1) << (DMA_ERR_ERR1_SHIFT))

#define DMA_ERR_ERR0_SHIFT             (0)
#define DMA_ERR_ERR0_MASK              ((1) << (DMA_ERR_ERR0_SHIFT))




/* Field definitions for HRS */
#define DMA_HRS_HRS31_SHIFT             (31)
#define DMA_HRS_HRS31_MASK              ((1) << (DMA_HRS_HRS31_SHIFT)) 

#define DMA_HRS_HRS30_SHIFT             (30)
#define DMA_HRS_HRS30_MASK              ((1) << (DMA_HRS_HRS30_SHIFT)) 

#define DMA_HRS_HRS29_SHIFT             (29)
#define DMA_HRS_HRS29_MASK              ((1) << (DMA_HRS_HRS29_SHIFT)) 

#define DMA_HRS_HRS28_SHIFT             (28)
#define DMA_HRS_HRS28_MASK              ((1) << (DMA_HRS_HRS28_SHIFT))

#define DMA_HRS_HRS27_SHIFT             (27)
#define DMA_HRS_HRS27_MASK              ((1) << (DMA_HRS_HRS27_SHIFT))

#define DMA_HRS_HRS26_SHIFT             (26)
#define DMA_HRS_HRS26_MASK              ((1) << (DMA_HRS_HRS26_SHIFT))

#define DMA_HRS_HRS25_SHIFT             (25)
#define DMA_HRS_HRS25_MASK              ((1) << (DMA_HRS_HRS25_SHIFT))

#define DMA_HRS_HRS24_SHIFT             (24)
#define DMA_HRS_HRS24_MASK              ((1) << (DMA_HRS_HRS24_SHIFT))

#define DMA_HRS_HRS23_SHIFT             (23)
#define DMA_HRS_HRS23_MASK              ((1) << (DMA_HRS_HRS23_SHIFT))

#define DMA_HRS_HRS22_SHIFT             (22)
#define DMA_HRS_HRS22_MASK              ((1) << (DMA_HRS_HRS22_SHIFT))

#define DMA_HRS_HRS21_SHIFT             (21)
#define DMA_HRS_HRS21_MASK              ((1) << (DMA_HRS_HRS21_SHIFT))

#define DMA_HRS_HRS20_SHIFT             (20)
#define DMA_HRS_HRS20_MASK              ((1) << (DMA_HRS_HRS20_SHIFT))

#define DMA_HRS_HRS19_SHIFT             (19)
#define DMA_HRS_HRS19_MASK              ((1) << (DMA_HRS_HRS19_SHIFT)) 

#define DMA_HRS_HRS18_SHIFT             (18)
#define DMA_HRS_HRS18_MASK              ((1) << (DMA_HRS_HRS18_SHIFT))

#define DMA_HRS_HRS17_SHIFT             (17)
#define DMA_HRS_HRS17_MASK              ((1) << (DMA_HRS_HRS17_SHIFT))

#define DMA_HRS_HRS16_SHIFT             (16)
#define DMA_HRS_HRS16_MASK              ((1) << (DMA_HRS_HRS16_SHIFT))

#define DMA_HRS_HRS15_SHIFT             (15)
#define DMA_HRS_HRS15_MASK              ((1) << (DMA_HRS_HRS15_SHIFT))

#define DMA_HRS_HRS14_SHIFT             (14)
#define DMA_HRS_HRS14_MASK              ((1) << (DMA_HRS_HRS14_SHIFT))

#define DMA_HRS_HRS13_SHIFT             (13)
#define DMA_HRS_HRS13_MASK              ((1) << (DMA_HRS_HRS13_SHIFT))

#define DMA_HRS_HRS12_SHIFT             (12)
#define DMA_HRS_HRS12_MASK              ((1) << (DMA_HRS_HRS12_SHIFT))

#define DMA_HRS_HRS11_SHIFT             (11)
#define DMA_HRS_HRS11_MASK              ((1) << (DMA_HRS_HRS11_SHIFT))

#define DMA_HRS_HRS10_SHIFT             (10)
#define DMA_HRS_HRS10_MASK              ((1) << (DMA_HRS_HRS10_SHIFT))

#define DMA_HRS_HRS9_SHIFT             (9)
#define DMA_HRS_HRS9_MASK              ((1) << (DMA_HRS_HRS9_SHIFT)) 

#define DMA_HRS_HRS8_SHIFT             (8)
#define DMA_HRS_HRS8_MASK              ((1) << (DMA_HRS_HRS8_SHIFT))

#define DMA_HRS_HRS7_SHIFT             (7)
#define DMA_HRS_HRS7_MASK              ((1) << (DMA_HRS_HRS7_SHIFT))

#define DMA_HRS_HRS6_SHIFT             (6)
#define DMA_HRS_HRS6_MASK              ((1) << (DMA_HRS_HRS6_SHIFT))

#define DMA_HRS_HRS5_SHIFT             (5)
#define DMA_HRS_HRS5_MASK              ((1) << (DMA_HRS_HRS5_SHIFT))

#define DMA_HRS_HRS4_SHIFT             (4)
#define DMA_HRS_HRS4_MASK              ((1) << (DMA_HRS_HRS4_SHIFT))

#define DMA_HRS_HRS3_SHIFT             (3)
#define DMA_HRS_HRS3_MASK              ((1) << (DMA_HRS_HRS3_SHIFT))

#define DMA_HRS_HRS2_SHIFT             (2)
#define DMA_HRS_HRS2_MASK              ((1) << (DMA_HRS_HRS2_SHIFT))

#define DMA_HRS_HRS1_SHIFT             (1)
#define DMA_HRS_HRS1_MASK              ((1) << (DMA_HRS_HRS1_SHIFT))

#define DMA_HRS_HRS0_SHIFT             (0)
#define DMA_HRS_HRS0_MASK              ((1) << (DMA_HRS_HRS0_SHIFT))



/* Field definitions for DCHPRIn */
#define DMA_DCHPRIn_ECP_SHIFT             (7)  
#define DMA_DCHPRIn_ECP_MASK              ((1) << (DMA_DCHPRIn_ECP_SHIFT)) 

#define DMA_DCHPRIn_DPA_SHIFT             (6)  
#define DMA_DCHPRIn_DPA_MASK              ((1) << (DMA_DCHPRIn_DPA_SHIFT)) 

#define DMA_DCHPRIn_GRPPRI_SHIFT          (4)
#define DMA_DCHPRIn_GRPPRI_MASK           ((0x03) << (DMA_DCHPRIn_GRPPRI_SHIFT)) 

#define DMA_DCHPRIn_CHPRI_SHIFT           (0)
#define DMA_DCHPRIn_CHPRI_MASK            ((0x0F) << (DMA_DCHPRIn_CHPRI_SHIFT)) 



/* Field definitions for TCDn_WORD0 */
#define DMA_TCDn_WORD0_SADDR_SHIFT           (0)
#define DMA_TCDn_WORD0_SADDR_MASK            ((0xFFFFFFFF) << (DMA_TCDn_WORD0_SADDR_SHIFT)) 



/* Field definitions for TCDn_WORD1 */
#define DMA_TCDn_WORD1_SMOD_SHIFT            (27)
#define DMA_TCDn_WORD1_SMOD_MASK             ((0x0000001F) << (DMA_TCDn_WORD1_SMOD_SHIFT)) 

#define DMA_TCDn_WORD1_SSIZE_SHIFT           (24)
#define DMA_TCDn_WORD1_SSIZE_MASK            ((0x00000007) << (DMA_TCDn_WORD1_SSIZE_SHIFT)) 

#define DMA_TCDn_WORD1_DMOD_SHIFT            (19)
#define DMA_TCDn_WORD1_DMOD_MASK             ((0x0000001F) << (DMA_TCDn_WORD1_DMOD_SHIFT)) 

#define DMA_TCDn_WORD1_DSIZE_SHIFT           (16)
#define DMA_TCDn_WORD1_DSIZE_MASK            ((0x00000007) << (DMA_TCDn_WORD1_DSIZE_SHIFT)) 

#define DMA_TCDn_WORD1_SOFF_SHIFT            (0)
#define DMA_TCDn_WORD1_SOFF_MASK             ((0x0000FFFF) << (DMA_TCDn_WORD1_SOFF_SHIFT)) 




/* Field definitions for TCDn_WORD2 */
#define DMA_TCDn_WORD2_SMLOE_SHIFT           (31)  
#define DMA_TCDn_WORD2_SMLOE_MASK            ((1) << (DMA_TCDn_WORD2_SMLOE_SHIFT)) 

#define DMA_TCDn_WORD2_DMLOE_SHIFT           (30)  
#define DMA_TCDn_WORD2_DMLOE_MASK            ((1) << (DMA_TCDn_WORD2_DMLOE_SHIFT)) 

#define DMA_TCDn_WORD2_MLOFF_SHIFT           (10)
#define DMA_TCDn_WORD2_MLOFF_MASK            ((0x000FFFFF) << (DMA_TCDn_WORD2_MLOFF_SHIFT)) 

#define DMA_TCDn_WORD2_NBYTES_OD_SHIFT          (0)
#define DMA_TCDn_WORD2_NBYTES_OD_MASK           ((0x000003FF) << (DMA_TCDn_WORD2_NBYTES_OD_SHIFT)) 

#define DMA_TCDn_WORD2_NBYTES_OE_SHIFT          (0)
#define DMA_TCDn_WORD2_NBYTES_OE_MASK           ((0x3FFFFFFF) << (DMA_TCDn_WORD2_NBYTES_OE_SHIFT)) 

#define DMA_TCDn_WORD2_NBYTES_SHIFT          (0)
#define DMA_TCDn_WORD2_NBYTES_MASK           ((0xFFFFFFFF) << (DMA_TCDn_WORD2_NBYTES_SHIFT)) 



/* Field definitions for TCDn_WORD3 */
#define DMA_TCDn_WORD3_SLAST_SHIFT           (0)
#define DMA_TCDn_WORD3_SLAST_MASK            ((0xFFFFFFFF) << (DMA_TCDn_WORD3_SLAST_SHIFT)) 



/* Field definitions for TCDn_WORD4 */
#define DMA_TCDn_WORD4_DADDR_SHIFT           (0)
#define DMA_TCDn_WORD4_DADDR_MASK            ((0xFFFFFFFF) << (DMA_TCDn_WORD4_DADDR_SHIFT)) 



/* Field definitions for TCDn_WORD5 */
#define DMA_TCDn_WORD5_ELINK_SHIFT    (31)  
#define DMA_TCDn_WORD5_ELINK_MASK     ((1) << (DMA_TCDn_WORD5_ELINK_SHIFT)) 

#define DMA_TCDn_WORD5_LINKCH_SHIFT    (25)
#define DMA_TCDn_WORD5_LINKCH_MASK     ((0x0000001F) << (DMA_TCDn_WORD5_LINKCH_SHIFT)) 

#define DMA_TCDn_WORD5_CITER_LE_SHIFT           (16)
#define DMA_TCDn_WORD5_CITER_LE_MASK            ((0x000001FF) << (DMA_TCDn_WORD5_CITER_LE_SHIFT)) 

#define DMA_TCDn_WORD5_CITER_SHIFT           (16)
#define DMA_TCDn_WORD5_CITER_MASK            ((0x00007FFF) << (DMA_TCDn_WORD5_CITER_SHIFT)) 

#define DMA_TCDn_WORD5_DOFF_SHIFT            (0)
#define DMA_TCDn_WORD5_DOFF_MASK             ((0x0000FFFF) << (DMA_TCDn_WORD5_DOFF_SHIFT)) 



/* Field definitions for TCDn_WORD6 */
#define DMA_TCDn_WORD6_DLASTSGA_SHIFT       (0)
#define DMA_TCDn_WORD6_DLASTSGA_MASK        ((0xFFFFFFFF) << (DMA_TCDn_WORD6_DLASTSGA_SHIFT)) 



/* Field definitions for TCDn_WORD7 */
#define DMA_TCDn_WORD7_ELINK_SHIFT           (31)
#define DMA_TCDn_WORD7_ELINK_MASK            ((1) << (DMA_TCDn_WORD7_ELINK_SHIFT)) 

#define DMA_TCDn_WORD7_LINKCH_SHIFT           (25)
#define DMA_TCDn_WORD7_LINKCH_MASK            ((0x1F) << (DMA_TCDn_WORD7_LINKCH_SHIFT)) 

#define DMA_TCDn_WORD7_BITER_LE_SHIFT           (16)
#define DMA_TCDn_WORD7_BITER_LE_MASK            ((0x000001FF) << (DMA_TCDn_WORD7_BITER_LE_SHIFT)) 

#define DMA_TCDn_WORD7_BITER_SHIFT           (16)
#define DMA_TCDn_WORD7_BITER_MASK            ((0x00007FFF) << (DMA_TCDn_WORD7_BITER_SHIFT)) 

#define DMA_TCDn_WORD7_BWC_SHIFT             (14)
#define DMA_TCDn_WORD7_BWC_MASK              ((0x00000003) << (DMA_TCDn_WORD7_BWC_SHIFT)) 

#define DMA_TCDn_WORD7_MAJORLINKCH_SHIFT    (8)
#define DMA_TCDn_WORD7_MAJORLINKCH_MASK     ((0x0000001F) << (DMA_TCDn_WORD7_MAJORLINKCH_SHIFT)) 

#define DMA_TCDn_WORD7_DONE_SHIFT            (7)  
#define DMA_TCDn_WORD7_DONE_MASK             ((1) << (DMA_TCDn_WORD7_DONE_SHIFT)) 

#define DMA_TCDn_WORD7_ACTIVE_SHIFT          (6)  
#define DMA_TCDn_WORD7_ACTIVE_MASK           ((1) << (DMA_TCDn_WORD7_ACTIVE_SHIFT)) 

#define DMA_TCDn_WORD7_MAJORELINK_SHIFT    (5)  
#define DMA_TCDn_WORD7_MAJORELINK_MASK     ((1) << (DMA_TCDn_WORD7_MAJORELINK_SHIFT)) 

#define DMA_TCDn_WORD7_ESG_SHIFT            (4)  
#define DMA_TCDn_WORD7_ESG_MASK             ((1) << (DMA_TCDn_WORD7_ESG_SHIFT)) 

#define DMA_TCDn_WORD7_DREQ_SHIFT           (3)  
#define DMA_TCDn_WORD7_DREQ_MASK            ((1) << (DMA_TCDn_WORD7_DREQ_SHIFT)) 

#define DMA_TCDn_WORD7_INTHALF_SHIFT        (2)  
#define DMA_TCDn_WORD7_INTHALF_MASK         ((1) << (DMA_TCDn_WORD7_INTHALF_SHIFT)) 

#define DMA_TCDn_WORD7_INTMAJOR_SHIFT         (1)  
#define DMA_TCDn_WORD7_INTMAJOR_MASK          ((1) << (DMA_TCDn_WORD7_INTMAJOR_SHIFT)) 

#define DMA_TCDn_WORD7_START_SHIFT           (0)  
#define DMA_TCDn_WORD7_START_MASK            ((1) << (DMA_TCDn_WORD7_START_SHIFT)) 
/*** End of bit definitions ***/

/*** define base address ***/
#define DMA0_BASE		0x40090000UL
#define DMA1_BASE		0x40092000UL

#define EDMA            (*(volatile struct EDMA_tag *)      DMA0_BASE)
#define EDMA1            (*(volatile struct EDMA_tag *)      DMA1_BASE)

#endif
